#include "mbed.h"
#include "rtos.h"
#include "stdio.h"
#include "common.h"
#include "lfsAccess.h"


bool lfsAccess::readSetting( void )
{
    FILE    *fp;
    char    *fname = "/local/dset.txt"; 
    char    s[150];
    int     c;
    int     data;
    
    fp = fopen(fname, "r");
    if( fp != NULL ){  // Open "set.txt" on the local file system for writing
        c = getc(fp);
        if( c != '#' ){
            return false;
        }
        else{
            fgets(s,100,fp);
            fscanf(fp,"%04d",&data); setValue.wchCtrl.cth_dram_mtr_f = data; fgets(s,100,fp); 
            fscanf(fp,"%04d",&data); setValue.wchCtrl.cth_dram_mtr_r = data; fgets(s,100,fp); 
            fscanf(fp,"%04d",&data); setValue.wchCtrl.cth_cabl_mtr_f = data; fgets(s,100,fp); 
            fscanf(fp,"%04d",&data); setValue.wchCtrl.cth_cabl_mtr_r = data; fgets(s,100,fp); 
            fscanf(fp,"%05d",&data); setValue.wchCtrl.dram_dmtr_x100 = data; fgets(s,100,fp); 
            fscanf(fp,"%05d",&data); setValue.wchCtrl.adj_val_x10000 = data; fgets(s,100,fp); 
            fscanf(fp,"%03d",&data); setValue.wchCtrl.res_resolution = data; fgets(s,100,fp); 
            fscanf(fp,"%03d",&data); setValue.wchCtrl.reserved_1 = data;    fgets(s,100,fp); 
            fscanf(fp,"%06d",&data); setValue.wchCtrl.move_interval_cw = data;    fgets(s,100,fp);
            fscanf(fp,"%06d",&data); setValue.wchCtrl.move_interval_ccw = data;    fgets(s,100,fp);
        }
        fclose(fp);
    }
    else{
        return false;
    }
    return true; 
}


bool lfsAccess::write_LFS_data( char *fname, char* data )
{
    FILE    *fp;
    
    fp = fopen( fname, "a" );
    if( fp != NULL ){ 
        fprintf(fp, data );
        fprintf(fp, "\r\n" );
        Thread::wait(30);
        fclose(fp);
        Thread::wait(30);
    }
    else{
        return false;
    }  
    return true;
}

