/*
 * Author: Edoardo De Marchi
 * Editor : Say Pulung
 * Country : Indonesia (Lampung)
 * Date: 26-04-15
 * Notes: Firmware for GPS U-Blox NEO-6M
*/

#include "main.h"
#include "string.h"
#include "rtos.h"
#include "mbed.h"
#include <stdint.h>
#include <math.h>
#include <ctype.h>
uint8_t hour, minute, seconds, year, month, day;
uint16_t milliseconds;
float latitude, longitude, geoidheight, altitude;
float speed, angle, magvariation, HDOP;
char lat, lon, mag;
bool fix;
float trunc(float v) {
    if(v < 0.0) {
        v*= -1.0;
        v = floor(v);
        v*=-1.0;
    } else {
        v = floor(v);
    }
    return v;
}
void parseRMC(char* buffer)
{
    char *p = buffer;

    // get time
    p = strchr(p, ',')+1;
    float timef = atof(p);
    uint32_t time = timef;
    hour = time / 10000;
    minute = (time % 10000) / 100;
    seconds = (time % 100);

    milliseconds = fmod((double) timef, 1.0) * 1000;

    p = strchr(p, ',')+1;
    // Serial.println(p);
    if (p[0] == 'A') 
      fix = true;
    else if (p[0] == 'V')
      fix = false;
    else
      fix= false;

    // parse out latitude
    p = strchr(p, ',')+1;
    latitude = atof(p);

    p = strchr(p, ',')+1;
    if (p[0] == 'N') lat = 'N';
    else if (p[0] == 'S') lat = 'S';
    else if (p[0] == ',') lat = 0;
    else lat=0;

    // parse out longitude
    p = strchr(p, ',')+1;
    longitude = atof(p);

    p = strchr(p, ',')+1;
    if (p[0] == 'W') lon = 'W';
    else if (p[0] == 'E') lon = 'E';
    else if (p[0] == ',') lon = 0;
    else lon=0;
    if(lat == 'S') {    latitude  *= -1; }
    if(lon == 'W') {    longitude *= -1; }
    float degrees = trunc(latitude / 100.0f);
    float minutes = latitude - (degrees * 100.0f);
    latitude = degrees + minutes / 60.0f;    
    
    degrees = trunc(longitude / 100.0f );
    minutes = longitude - (degrees * 100.0f);
    longitude = degrees + minutes / 60.0f;
    // speed
    p = strchr(p, ',')+1;
    speed = atof(p);

    // angle
    p = strchr(p, ',')+1;
    angle = atof(p);

    p = strchr(p, ',')+1;
    uint32_t fulldate = atof(p);
    day = fulldate / 10000;
    month = (fulldate % 10000) / 100;
    year = (fulldate % 100);

}
void Init()
{
    gps.baud(9600);
    pc.baud(9600);

    pc.printf("Init OK\n");
}

void readGPSThread(void const *args)
{
    char c;
    while(true) 
    {
        if(gps.readable())
        { 
            if(gps.getc() == '$');           // wait a $
            {
                for(int i=0; i<sizeof(cDataBuffer); i++)
                {
                    c = gps.getc();
                    if( c == '\r' )
                    {
                        
                        
                        if(strncmp(cDataBuffer,"$GPRMC",6)==0)
                        {
                            parseRMC(cDataBuffer);
                        }
                        //pc.printf("Longitude = %f, Latitude = %f, Speed = %f,Angle = %f, Day = %d, Month = %d, Year = %d,H = %d, M = %d, S = %d\n",longitude,latitude,speed,angle,day,month,year,hour,minute,seconds);
                        i = sizeof(cDataBuffer);
                    }
                    else
                    {
                        cDataBuffer[i] = c;
                    }                 
                }
            }
            
         } 
    }
}

int main() 
{   
    Init();
    DigitalOut l1(LED1);
    Thread gpsReader(readGPSThread);
    
    while(1){
        l1 = 1;
        wait(0.5);
        l1=0;
        wait(0.5);
        pc.printf("Longitude = %f, Latitude = %f, Speed = %f,Angle = %f, Day = %d, Month = %d, Year = %d,H = %d, M = %d, S = %d\n",longitude,latitude,speed,angle,day,month,year,hour,minute,seconds);
    }
    
}





