#ifndef _omuni_
#define _omuni_

#include "speed_control.hpp"

#define THETA_ADDJUST   0.69f

class omuni
{
private:
    I2C *i2c;
    speed_control *o[3];
    Timer time, t;
    float tvx, tvy, tomega; 
    float vx, vy, omega, theta;
    float R, d;
    int addr[3];
    float v[3];
    bool f;
public:
    omuni(I2C *i, TIM_TypeDef *timer_type0, TIM_TypeDef *timer_type1, TIM_TypeDef *timer_type2, size_t pulse_per_revol, float _cy_ms, int a[3], float _R, float _d);
    void set_pid(int n, float _kp, float _ki, float _kd);
    void set_speed(float vx, float vy);
    void set_speed(float vx, float vy, float omega);
    void set_speed(float _vx, float _vy, float _omega, bool _f);
    void renew_theta();
    bool renew_speed();
    void _set_speed();
    void drive();
    void reset_theta();
    float get_theta();
    float get_vx();
    float get_vy();
};

#endif
