#ifndef __SPEED_CONTROL__
#define __SPEED_CONTROL__

#include "mbed.h"
#include "rotary_encoder_ab_phase.hpp"

class speed_control
{
private:
    rotary_encoder_ab_phase *e;
    Timer t;
    float kp, ki, kd;
    float f1, f2, diff[2], m, dm, j;
    float pulse_per_revol, cy_ms;
    float target_value, sensor_value;
    unsigned long time_counter;
    int32_t e_value[10], pre_counts;
    char duty;
    bool rev;
    
public:
    speed_control(TIM_TypeDef *timer_type, float _pulse_per_revol, float _cy_ms);
    void change_direction(bool _rev);
    void set_speed(float _target_value);
    void set_pid(float _kp, float _ki, float _kd);
    bool check_get_speed();
    char get_duty();
    float get_speed();
};

#endif