#ifndef _omuni_
#define _omuni_

#include "speed_control.hpp"
#include "L3GD20_i2c.hpp"

#define THETA_ADDJUST   0.69f

class Omuni
{
private:
    I2C *i2c;
    l3gd20 *gyro;
    speed_control *o[3];
    Timer time, t;
    double tvx, tvy, tomega; 
    double vx, vy, omega, theta;
    double R, d;
    int addr[3];
    double v[3];
    bool f;
    bool crevx, crevy;
public:
    Omuni(I2C *i, TIM_TypeDef *timer_type0, TIM_TypeDef *timer_type1, TIM_TypeDef *timer_type2, size_t pulse_per_revol, double _cy_ms, const int a[3], double _R, double _d);
    void set_pid(int n, double _kp, double _ki, double _kd);
    void change_motor_direction(int n, bool _rev);
    void change_coordinates_direction(bool _crevx, bool _crevy);
    void set_speed(double vx, double vy);
    void set_speed(double vx, double vy, double omega);
    void set_speed(double _vx, double _vy, double _omega, bool _f);
    void renew_theta();
    bool renew_speed();
    void _set_speed();
    void drive();
    void reset_theta();
    double get_theta();
    double get_vx();
    double get_vy();
};

#endif
