#ifndef __L3GD20_I2C__
#define __L3GD20_I2C__

#include "mbed.h"

class l3gd20
{
    I2C *i;
    Timer t;
    long pre_time_ms;
    char addr;
    const char ADDR_WHO_AM_I;
    const char ADDR_CTRL_REG1;
    const char ADDR_CTRL_REG2;
    const char ADDR_CTRL_REG3;
    const char ADDR_CTRL_REG4;
    const char ADDR_CTRL_REG5;
    const char ADDR_OUT_TEMP;
    const char ADDR_STATUS_REG;
    const char ADDR_OUT_X_L;
    const char ADDR_OUT_X_H;
    const char ADDR_OUT_Y_L;
    const char ADDR_OUT_Y_H;
    const char ADDR_OUT_Z_L;
    const char ADDR_OUT_Z_H;
    double decom;
    double angleDeg[3];
    double omegaOffset[3];
    bool stpFlg;
public:
    l3gd20(I2C *_i, bool SA0);
    char read_reg(char reg);
    void write_reg(char reg, char data);
    bool who_am_i();
    void set_range(int dps);
    int16_t get_raw_omega(char se);
    void apply_offset();
    void start();
    void reset();
    void stop();
    double trapezoid_integr(double data, double ex_data, double period);
    void renew_angle();
    void get_angle_deg(double *a);
    void get_angle_rad(double *a);
};

#endif