#include "mbed.h"
#include "FXOS8700Q.h"             // Sensor Header File
#include "math.h"
#include <string>

FXOS8700Q_acc acc( PTE25, PTE24, FXOS8700CQ_SLAVE_ADDR1);    // Proper Ports and I2C Address for K64F Freedom board
MotionSensorDataUnits acc_data;

Serial pc(USBTX, USBRX);            // UART for Tera-Term
Serial device(PTC17, PTC16);

void updateSensor();                // Updates sensor values in "acc_data"

int main()
{
    pc.baud(115200);
    device.baud(115200);
    
    acc.enable();

    while (true) {
        updateSensor();
        pc.printf("Current State: ");
        
        if (-0.1 < acc_data.x && acc_data.x < 0.1) {
            device.printf("1");
            pc.printf("1\n");
        } else if (0.1 < acc_data.x && acc_data.x < 0.55) {
            device.printf("2");
            pc.printf("2\n");
        } else if (0.55 < acc_data.x && acc_data.x < 1.0) {
            device.printf("3");
            pc.printf("3\n");
        } else if (-0.55 < acc_data.x && acc_data.x < -0.1) {
            device.printf("4");
            pc.printf("4\n");
        } else if (-1.0 < acc_data.x && acc_data.x < -0.55) {
            device.printf("5");
            pc.printf("5\n");
        } else {
            device.printf("1");
            pc.printf("1\n");
        }
        wait(1);
    }
}

void updateSensor() {
    acc.getAxis(acc_data);
    //pc.printf("\nACC: X=%1.4f Y=%1.4f Z=%1.4f  \n", acc_data.x, acc_data.y, acc_data.z);  // Prints current sensor values
}