#include "mbed.h"
#include "ESP8266.h"               // ESP8266 Header File
#include "FXOS8700Q.h"             // Sensor Header File
#include "math.h"
#include <string>

// WIFI Configs
#define WIFI_SSID "Redmi"
#define WIFI_PASS "132132123"
ESP8266 esp(PTC17, PTC16, 115200);  // baud rate for ESP8266

// ThingSpeak Configs
#define IP "184.106.153.149"        // IP Address of "api.thingspeak.com\"

FXOS8700Q_acc acc( PTE25, PTE24, FXOS8700CQ_SLAVE_ADDR1);    // Proper Ports and I2C Address for K64F Freedom board
MotionSensorDataUnits acc_data;
Serial pc(USBTX,USBRX);             // Used for printing Tera Term

char snd[255],rcv[1000];

// Functions Declaration
void updateSensor();                // Updates sensor values in "acc_data"
void esp_initialize();              // Initializes connection with the Wi-Fi
void updateCloud();                 // Uploads data to the thingspeak cloud

int main()
{
    pc.baud(115200);                //Baud Rate for TeraTerm
    pc.printf("Start\n");
    
    esp_initialize();
    acc.enable();
    
    while(1) {
        updateSensor();
        updateCloud();
        wait(20);
    }
}

void updateSensor() {
    acc.getAxis(acc_data);
    pc.printf("\nACC: X=%1.4f Y=%1.4f Z=%1.4f  ", acc_data.x, acc_data.y, acc_data.z);  // Prints current sensor values
}

void esp_initialize(void) {    
    pc.printf("Initializing ESP\r\n"); 
      
    pc.printf("Reset ESP\r\n"); 
    esp.Reset();                            // RESET ESP
    wait(2);
    
    strcpy(snd,"AT");
    esp.SendCMD(snd);                       // Runs the AT command on ESP8266
    wait(0.1);
    
    strcpy(snd,"AT+CWMODE=1");              // Set Wi-Fi Mode
    esp.SendCMD(snd);
    wait(2);

    strcpy(snd,"AT+CWJAP=\"");              // Connect to the Wi-Fi network
    strcat(snd,WIFI_SSID);
    strcat(snd,"\",\"");
    strcat(snd,WIFI_PASS);
    strcat(snd,"\"");
    esp.SendCMD(snd);
    wait(5);
    
    esp.RcvReply(rcv, 400);       
    pc.printf("\n %s \n", rcv); 
    
    strcpy(snd,"AT+CIPMUX=0");              // Set to single connection
    esp.SendCMD(snd);
    esp.RcvReply(rcv, 400);       
    pc.printf("\n %s \n", rcv); 
}

void updateCloud(){
    float x_axis = 0.0f, y_axis = 0.0f;
    wait(2.0f);
    x_axis   = acc_data.x;
    y_axis   = acc_data.y;
    //ESP updates the Status of Thingspeak channel//
    
    strcpy(snd,"AT+CIPSTART=");             // Initialize TCP connection
    strcat(snd,"\"TCP\",\"");
    strcat(snd,IP);
    strcat(snd,"\",80");
    esp.SendCMD(snd);
    //wait(2);                                                    
    esp.RcvReply(rcv, 1000);
    pc.printf("R\r\n%s",rcv);
    wait(1);
    
    sprintf(snd,"GET https://api.thingspeak.com/update?api_key=CSV6JACFC3TGG6MO&field1=%f&field2=%f\r\n",x_axis, y_axis);
    
    int i=0;
    for(i=0;snd[i]!='\0';i++);
    i++;
    char cmd[255];
    
    sprintf(cmd,"AT+CIPSEND=%d",i);             //Send Number of open connection and Characters to send 
    esp.SendCMD(cmd);
    wait(1);
    
    esp.SendCMD(snd);                       //Post value to thingspeak channel
    pc.printf("S\r\n%s",snd);
       
}