#include "mbed.h"
#include "rtos.h"
#include "AnalogBuffer.h"

const int SEUIL_ANALOG = 0x2000;

DigitalIn en_1(p15);
DigitalIn en_2(p16);
AnalogIn ea_1(p19);
AnalogIn ea_2(p20);

bool digital_1;
bool digital_2;

AnalogBuffer ab_1;
AnalogBuffer ab_2;

Ticker ticker1, ticker2;

Thread *t1, *t2;

Serial pc(USBTX, USBRX); // tx, rx

typedef struct {
    bool isAnalog;
    bool digital;
    unsigned short analog;
    unsigned short id;
    time_t rtc_time;
} mail_t;

Mail<mail_t, 16> mail_box;

//Benchmark section.
Timer timer;
unsigned int old;
unsigned int newT;

void lecture_analog(void const *args)
{
    unsigned short old_average_1 = 0;
    unsigned short old_average_2 = 0;
    while (true) {
        Thread::signal_wait(0x1);
        old = newT;
        newT = timer.read_ms();
        pc.printf("Time : %d\n",newT-old);
        time_t rtc_time = time(NULL); // lecture de l'étampe temporelle
        ab_1.put(ea_1.read_u16()); // lecture des échantillons analogiques
        ab_2.put(ea_2.read_u16());
        unsigned short new_average_1 = ab_1.average(); // calcul de la nouvelle moyenne courante
        unsigned short new_average_2 = ab_2.average();
        int diff_1 = abs(new_average_1 - old_average_1);
        int diff_2 = abs(new_average_2 - old_average_2);

        if (diff_1 > SEUIL_ANALOG) {
            mail_t* mail = mail_box.alloc();
            mail->isAnalog = true;
            mail->analog = new_average_1;
            mail->rtc_time = rtc_time;
            mail->id = 1;
            mail_box.put(mail);
            old_average_1 = new_average_1;
        }
        if (diff_2 > SEUIL_ANALOG) {
            mail_t* mail = mail_box.alloc();
            mail->isAnalog = true;
            mail->analog = new_average_2;
            mail->rtc_time = rtc_time;
            mail->id = 2;
            mail_box.put(mail);
            old_average_2 = new_average_2;
        }
    }
}



void lecture_num(void const *args)
{
    while (true) {
        Thread::signal_wait(0x1);
        //old = newT;
//        newT = timer.read_ms();
//        pc.printf("Time : %d\n",newT-old);
        time_t rtc_time = time(NULL); // lecture de l'étampe temporelle
        bool new_digital_1 = en_1.read();  // lecture des échantillons numériques
        bool new_digital_2 = en_2.read();  // lecture des échantillons numériques

        if ((new_digital_1 != digital_1) || (new_digital_2 != digital_2)) {
            // prise en charge du phénomène de rebond
            Thread::wait(50);
            if (new_digital_1 != digital_1) {
                new_digital_1 = en_1.read();
                if (new_digital_1 != digital_1) {
                    // génération éventuelle d'un événement
                    mail_t* mail = mail_box.alloc();
                    mail->isAnalog = false;
                    mail->digital = new_digital_1;
                    mail->rtc_time = rtc_time;
                    mail->id = 1;
                    mail_box.put(mail);
                    digital_1 = new_digital_1;
                }
            }
            if (new_digital_2 != digital_2) {
                new_digital_2 = en_2.read();
                if (new_digital_2 != digital_2) {
                    // génération éventuelle d'un événement
                    mail_t* mail = mail_box.alloc();
                    mail->isAnalog = false;
                    mail->digital = new_digital_2;
                    mail->rtc_time = rtc_time;
                    mail->id = 2;
                    mail_box.put(mail);
                    digital_2 = new_digital_2;
                }
            }
        }
    }
}

void collection(void const *args)
{
    while (true) {
        // attente et lecture d'un événement
        // écriture de l'événement en sortie (port série)
        osEvent evt = mail_box.get();
        if (evt.status == osEventMail) {
            mail_t *mail = (mail_t*)evt.value.p;
            if(mail->isAnalog) {
                pc.printf("Analog : (%d,%X) %s", mail->id, mail->analog, ctime(&mail->rtc_time));
            } else {
                pc.printf("Digital : (%d,%X) %s", mail->id, mail->digital, ctime(&mail->rtc_time));
            }
            mail_box.free(mail);
        }
    }
}

void wakeupThread1()
{
    t1->signal_set(0x1);
}

void wakeupThread2()
{
    t2->signal_set(0x1);
}

int main()
{
    // initialisation du RTC
    set_time(1485732233);

    timer.start();

    // démarrage des tâches
    Thread analogThread(lecture_analog);
    Thread digitalThread(lecture_num);
    Thread collectionThread(collection);

    t1 = &analogThread;
    t2 = &digitalThread;

    ticker1.attach(&wakeupThread1, 0.250);
    ticker2.attach(&wakeupThread2, 0.100);

    while(1);
}
