#include "mbed.h"
#include "m3pi_ng.h"
#include "cmath"
#include "iostream"
#include "btbee.h"
 
 
using namespace std;
 
m3pi thinggy;
btbee btbee; 

DigitalOut mbed_led[] = {(LED1), (LED2),(LED3), (LED4)};
DigitalOut m3pi_led[] = {(p13), (p14), (p15), (p16), (p17), (p18), (p19), (p20)};
DigitalIn m3pi_pb(p21);
 
int main() {
    
    //..................................................................................................\\
    //......BlueTooth Communication.....................................................................\\
    //..................................................................................................\\

   // initialization stuff ////////////////////////////////////////////////////////////////////////////////////////////////////
   thinggy.locate(0,1);
   btbee.reset();
   for (int i = 0; i <4; i++) {
       mbed_led[i] = 0;
   }
   for (int i = 0; i <8; i++) {
       m3pi_led[i]=0;
   }
   m3pi_pb.mode(PullUp); // expected would be 1 when pb is pressed, 0 when not, opposite is the case

   // end initialization stuff ////////////////////////////////////////////////////////////////////////////////////////////////

  
   thinggy.locate(0,0);
   thinggy.printf("%s","ThySeeMe");
   thinggy.locate(0,1);
   thinggy.printf("%s","Rolling");

   // wait for the user to push P21, should be pressed when the bt link is established (green led "link")
   while(m3pi_pb) {
       m3pi_led[0]=!m3pi_led[0];
       wait(0.1);
   }

   int iline=1;
   char arr_read[30]; // this should be long enough to store any reply coming in over bt.
   int  chars_read;   // number of chars read in a bt reply
   
   while (true) {
       // this writes "Line 001\n" to "Line 005\n" and then "end\n" to the btbee
       if ( btbee.writeable() ) {
           if (iline==6) {
               btbee.printf("Your Turn!\n");
               iline++;
           }//if
           else {
               if (iline <6){
               btbee.printf("Line %0.3d \n",iline);
               m3pi_led[0]=0;
               thinggy.locate(0,0);
               thinggy.printf("Sent %0.3d",iline);
               iline++;
               }
           }//else
       }//if_write

       // check for answers after each write /not write
       while ( btbee.readable() ) {
           btbee.read_all(arr_read, 30, &chars_read );
           thinggy.locate(0,0);
           thinggy.cls();
           thinggy.printf("IGotMsg!");
           if (arr_read[0] == 'l'){
               thinggy.locate(0,1);
               thinggy.cls();
               thinggy.printf("TurningL");
               thinggy.left_motor(0.2);
               thinggy.right_motor(-0.2);
               }
           else if (arr_read[0] == 'r'){
               thinggy.locate(0,1);
               thinggy.cls();
               thinggy.printf("TurningR");
               thinggy.left_motor(-0.2);
               thinggy.right_motor(0.2);
               // add code to turn right
               }
           else if (arr_read[0] == 'f'){
               thinggy.locate(0,1);
               thinggy.cls();
               thinggy.printf("GoingFwd");
               thinggy.forward(0.1);
               }
           else if (arr_read[0] == 's'){
               thinggy.locate(0,1);
               thinggy.cls();
               thinggy.printf("Stopping");
               thinggy.stop();
               }    
       }//while_readable
       wait(0.1);
   }//while_true

}//main