#include "mbed.h"
#include "TextLCD.h"

InterruptIn tombol(p8);

DigitalOut Gate(p18);
DigitalOut Buzzer(p19);
DigitalOut rw(p21);
DigitalOut indikator(LED1);
DigitalOut indikator2(LED2);
Serial RFID(p13, p14);

TextLCD lcd(p20, p22, p23, p24, p25, p26); //rs, e, d4-d7

char dataIn;

void hlm_home()
{
    rw = 0;
    lcd.cls();
    lcd.locate(0,3);
    lcd.printf("Bandung Techno Park");
    lcd.locate(2,1);
    lcd.printf("e-Parking System");
    //rw =1;
}

void handle()
{
    if(RFID.readable())   //Jika ada data serial masuk
    {
        //aksi ketika ada serial interrupt masuk
        dataIn = RFID.getc();
        indikator = 1;
        Buzzer = 1;
        
        //RFID.putc(dataIn);
        //RFID.printf("\r\n");
        
        if (dataIn == 0x04)
        {
            //RFID.putc(dataIn);
            //RFID.printf("\r\n");
            
            indikator2 = 1;
            Gate = 1;
            wait (0.1);
            Gate = 0;
            Buzzer = 0;
            indikator = 0;
            indikator2 = 0;
            
            rw = 0;        
            lcd.cls();
            lcd.locate(0,2);
            lcd.printf("Bandung Techno Park");
            lcd.locate(5,0);
            lcd.printf("Welcome To");
            //rw = 1;
        }
        else 
        {
            wait(0.1);
            Buzzer = 0;
            indikator = 0;
            indikator2 = 0;
                        
            rw = 0;
            lcd.cls();
            lcd.locate(8,1);
            lcd.printf("Sorry");
            lcd.locate(4,2);
            lcd.printf("Access Denied");
            //rw = 1;           
        }
        
        wait(2);
        hlm_home();
    }
    return; 
}

void open()
{   
    indikator2 = 1;
    Gate = 1;
    wait (0.1);
    Gate = 0;
    indikator2 = 0;
    
    rw = 0;
    lcd.cls();
    lcd.locate(0,2);
    lcd.printf("Bandung Techno Park");
    lcd.locate(5,0);
    lcd.printf("Welcome To");
    //rw = 1;  
    wait(2);
    hlm_home();  
}

int main() 
{
    rw = 0;
    hlm_home();   
    
    wait(2);
    
    RFID.attach(handle);
    RFID.putc(0x04);
    
    tombol.fall(&open);
    
    indikator = 0;
    indikator2 = 0;
    Gate = 0;
     
    while (1) 
    {

    }
}
