00001 
00002 /*
00003 Copyright (c) 2010 Donatien Garnier (donatiengar [at] gmail [dot] com)
00004  
00005 Permission is hereby granted, free of charge, to any person obtaining a copy
00006 of this software and associated documentation files (the "Software"), to deal
00007 in the Software without restriction, including without limitation the rights
00008 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
00009 copies of the Software, and to permit persons to whom the Software is
00010 furnished to do so, subject to the following conditions:
00011  
00012 The above copyright notice and this permission notice shall be included in
00013 all copies or substantial portions of the Software.
00014  
00015 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
00016 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
00017 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
00018 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
00019 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
00020 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
00021 THE SOFTWARE.
00022 */
00023 
00024 /** \file
00025 Ethernet network interface header file
00026 */
00027 
00028 #ifndef ETHERNETNETIF_H
00029 #define ETHERNETNETIF_H
00030 
00031 struct netif;
00032 
00033 #include "mbed.h"
00034 
00035 #include "if/lwip/LwipNetIf.h"
00036 #include "lwip/dhcp.h"
00037 
00038 ///Ethernet network interface return codes
00039 enum EthernetErr
00040 {
00041   __ETH_MIN = -0xFFFF,
00042   ETH_TIMEOUT, ///<Timeout during setup
00043   ETH_OK = 0 ///<Success
00044 };
00045 
00046 ///Ethernet network interface
00047 /**
00048 This class provides Ethernet connectivity to the stack
00049 */
00050 class EthernetNetIf : public LwipNetIf
00051 {
00052 public:
00053   ///Instantiates the Interface and register it against the stack, DHCP will be used
00054   /**
00055   * An optional hostname can be specified which will be passed to the DHCP server.
00056   * Examples without and with hostname specified:
00057   *
00058   * @code
00059   * EthernetNetIf eth();
00060   * @endcode
00061   * @code
00062   * EthernetNetIf eth("mbedSE");
00063   * @endcode
00064   */
00065   EthernetNetIf(const char* hostname = NULL); //W/ DHCP
00066 
00067   ///Instantiates the Interface and register it against the stack, DHCP will not be used
00068   /**
00069   IpAddr is a container class that can be constructed with either 4 bytes or no parameters for a null IP address.
00070   */
00071   EthernetNetIf(IpAddr ip, IpAddr netmask, IpAddr gateway, IpAddr dns); //W/o DHCP
00072   virtual ~EthernetNetIf();
00073   
00074   ///Brings the interface up
00075   /**
00076   Uses DHCP if necessary
00077   @param timeout_ms : You can set the timeout parameter in milliseconds, if not it defaults to 15s
00078   @return : ETH_OK on success or ETH_TIMEOUT on timeout
00079   */
00080   EthernetErr setup(int timeout_ms = 15000);
00081 
00082   virtual void poll();
00083   
00084   ///Returns an array containing the hardware address
00085   const char* getHwAddr() const;
00086   
00087 private:
00088   Timer m_ethArpTimer;
00089   Timer m_dhcpCoarseTimer;
00090   Timer m_dhcpFineTimer;
00091   Timer m_igmpTimer;
00092     
00093   bool m_useDhcp;
00094 
00095   netif* m_pNetIf;
00096   
00097   IpAddr m_netmask;
00098   IpAddr m_gateway;
00099   
00100   const char* m_hostname;
00101   dhcp* m_pDhcp;
00102   bool m_setup;
00103 };
00104 
00105 #endif
00106 
