/*
SAMPLE
#include "mbed.h"
#include "MakeSequencer.h"

#define SIZE 6
#define ArraySize(array) (sizeof(array) / sizeof(array[0]))

//A row is from 1

LocalFileSystem local("local");
int array[SIZE] = {};

int main()
{
    FILE *fp = fopen( "/local/out.txt", "r");
    MakeSequencer code(fp);
    code.getGcode(2,ArraySize(array),array);//getGcode(int row,int aSize, int* array)
                                            //array will get Gcode of a "int row" line
    for(int i = 0;i < ArraySize(array);i++)
        printf("%d,",array[i]);
    printf("\n\r%d\n\r",code.getGcodeSize());   //getGcodeSize()
                                               //return Gcode row

Solves arrays bug(Dynamic allocation,Initialize,release)
//out.txt
//x0y0z0a0b0c0
//x10y10
//x20a20c20
//c30                            
 
//output
//20,10,0,20,0,20, (3 rows data output)
//4                (this code has 4 rows)
*/

#include "MakeSequencer.h"
MakeSequencer::MakeSequencer(FILE *fp)
{
    _fp=fp;
    FileOpen();
}

bool MakeSequencer::FileOpen()
{
    if ( _fp == NULL )
    { 
        printf("Exception");
        return false;
    }
    else
        ReadGcode();
         
    fclose(_fp);
    return true;
}

void MakeSequencer::getGcode(int row,int aSize, int* array)
{
    for(int i = 0;i < aSize;i++)
    {
        array[i] = _data[i][row];
    }
}

int MakeSequencer::getGcodeSize()
{
    return _codesize+1;
}

bool MakeSequencer::ReadGcode()
{
    char * _buf     = new char[BUF];
    int  *_tempnum  = new int[ARRAY_EREMENT];
    char **_element = new char*[ARRAY_EREMENT];
    bool **_check   = new bool*[ARRAY_EREMENT];
    for (int y = 0; y < ARRAY_EREMENT; y++) 
    {
        _element[y] = new char[CODE_LENGTH];
        _check[y]   = new bool[CODE_LENGTH];
    }
    
    for(int b = 0;b < BUF;b++)
        _buf[b] = 0;
    
    for(int x = 0;x < ARRAY_EREMENT;x++)
    {
        _tempnum[x] = 0;
        for(int y = 0;y < CODE_LENGTH;y++)
        {
            _data   [x][y] = 0;
            _element[x][y] = ' ';
            _check  [x][y] = true;
        }
    }
    _ele = 0;
    for(int i = 0;fgets(_buf,BUF, _fp) != NULL;i++)
    {
        _codesize = i;
        if(i > CODE_LENGTH)
            return false;
        else
        {
            string *_tempstr = new string[ARRAY_EREMENT];
            for(int x = 0;x < ARRAY_EREMENT;x++)
                _tempstr[x] = " ";
                
            _count = -1;
            
            for(int n = 0;_buf[n] != '\0';n++)
            {
                char _char = _buf[n];
                if((_char >= 'a'&& _char <= 'z') || (_char >= 'A' && _char <= 'Z'))
                {
                    _count++;                    
                    if(_char != _element[_count][0] && i != 0)
                    {
                        for(int p = 0;p < _ele;p++)
                        {
                            if(_char == _element[p][0])
                            {
                                _element[p][i] = _char;
                                _count = p;
                                _check[p][i] = false;
                                break;
                            }
                        }
                    }
                    else
                        _element[_count][i] = _char;
                    if(i == 0)
                        _ele++;
                }
                else if(_char >= '0'&& _char <= '9' || _char <= '-')
                {
                    _tempstr[_count] = _tempstr[_count] + _char;
                }   
                
                else if(_char == '\n' || _char == '\r')
                {
                }
                else
                    return false;
            }
            for(int n = 0;n < _ele;n++)
            {
                _tempnum[n] = atoi(_tempstr[n].c_str());
                _data[n][i] = (i != 0 && _check[n][i] && _element[n][i] != _element[n][0])
                            ? _data[n][i-1]
                            : _tempnum[n];
                            
                _element[n][i] = (i != 0 && _check[n][i] && _element[n][i] != _element[n][0])
                            ? _element[n][0]
                            : _element[n][i];
            }
            delete[] _tempstr;
        }
    }
    
    for (int y = 0; y < ARRAY_EREMENT;y++) 
    {
        delete[] _check[y];
        delete[] _element[y];
    }
    delete[] _tempnum;
    delete[] _buf;
    delete[] _check;
    delete[] _element;
    
    return true;
}