/*
sample

#include "mbed.h"
#include "MakeSequencer.h"

//A row is from 1

LocalFileSystem local("local");
int array[5] = {};

int main()
{
    FILE *fp = fopen( "/local/out.txt", "r");
    MakeSequencer code(fp);
    code.getGcode(1,sizeof(array)/sizeof(int),array);        //getGcode(int row,int aSize, int* array)
                                                             //array will get Gcode of a "int row" line
    for(int i = 0;i < sizeof(array)/sizeof(int);i++)
        printf("%d,",array[i]);
    printf("\n\r%d",code.getGcodeSize());                    //getGcodeSize()
                                                             //return Gcode row
}
*/


#include "MakeSequencer.h"


MakeSequencer::MakeSequencer(FILE *fp)
{
    _fp=fp;
    FileOpen();
 
}

bool MakeSequencer::FileOpen()
{
    if ( _fp == NULL )
    { 
        printf("Exception");
        return false;
    }
    else
        ReadGcode();
         
    fclose(_fp);
    return true;
}

void MakeSequencer::getGcode(int row,int aSize, int* array)
{
    for(int i = 0;i < aSize;i++)
    {
        array[i] = _data[i][row-1];
    }
}

int MakeSequencer::getGcodeSize()
{
    return _codesize+1;
}

bool MakeSequencer::ReadGcode()
{
    //char * _buf     = new char[BUF];
    char _buf[BUF];
    int  *_tempnum  = new int[ARRAY_EREMENT];
    char **_element = new char*[ARRAY_EREMENT];
    bool **_check   = new bool*[ARRAY_EREMENT];
    for (int a = 0; a < ARRAY_EREMENT; a++) 
    {
        _element[a] = new char[CODE_LENGTH];
        _check[a]   = new bool[CODE_LENGTH];
    }
    _ele = 0;
    for(int i = 0;fgets(_buf,sizeof(_buf), _fp) != NULL;i++)
    {
        _codesize = i;
        
        if(i > CODE_LENGTH)
            return false;
        else
        {
            string *_tempstr = new string[ARRAY_EREMENT];
            _count = -1;
            
            for(int n = 0;n < ARRAY_EREMENT;n++)//bool array Initialize
            {
                for(int p = 0;p < CODE_LENGTH;p++)
                    _check[n][p] = true;
            }
            
            for(int n = 0;_buf[n] != '\0';n++)
            {
                _char = _buf[n];
                if((_char >= 'a'&& _char <= 'z') || (_char >= 'A' && _char <= 'Z'))
                {
                    _count++;                    
                    if(_char != _element[_count][0] && i != 0)
                    {
                        for(int p = 0;p < _ele;p++)
                        {
                            if(_char == _element[p][0])
                            {
                                _element[p][i] = _char;
                                _count = p;
                                _check[p][i] = false;
                                break;
                            }
                        }
                    }
                    else
                        _element[_count][i] = _char;
                    if(i == 0)
                        _ele++;
                }
                else if(_char >= '0'&& _char <= '9' || _char <= '-')
                {
                    _tempstr[_count] = _tempstr[_count] + _char;
                }   
                
                else if('\n' || '\r')
                {
                }
                else
                    return false;
            }
            printf("#(%d) ",i);
            for(int n = 0;n < _ele;n++)
            {
                _tempnum[n] = atoi(_tempstr[n].c_str());
                _data[n][i] = (i != 0 && _check[n][i] && _element[n][i] != _element[n][0])
                            ? _data[n][i-1]
                            : _tempnum[n];
                            
                _element[n][i] = (i != 0 && _check[n][i] && _element[n][i] != _element[n][0])
                            ? _element[n][0]
                            : _element[n][i];
                printf("%c:%d",_element[n][i],_data[n][i]);
            }
            printf("\n\r");
            //delete[] _tempstr;
        }
        
    }
    for (int a = 0; a < ARRAY_EREMENT; a++) 
    {
        delete[] _data[a];
        delete[] _check[a];
        delete[] _element[a];
    }
    //delete[] _buf;
    //delete[] _data;
    delete[] _element;
    delete[] _check;
    delete[] _tempnum;
    return true;
}