#include "L3GD20.h"

L3GD20::L3GD20(PinName sda, PinName scl) : i2c(sda, scl), address(0xD6)
{
    turnOn();
}

L3GD20::~L3GD20()
{
}

void L3GD20::turnOn(void)
{
    writeByte(0x20, 0x0F); // turn on a sensor
}

void L3GD20::readData(double &x, double &y, double &z)
{
    static const double rate = 0.00875;
    char h, l;
    l = readByte(0x28);
    h = readByte(0x29);
    x = (short)(h << 8 | l) * rate;
    l = readByte(0x2A);
    h = readByte(0x2B);
    y = (short)(h << 8 | l) * rate;
    l = readByte(0x2C);
    h = readByte(0x2D);
    z = (short)(h << 8 | l) * rate;
}

char L3GD20::readByte(char reg)
{
    static const int data_len = 1;
    i2c.write(address, &reg, data_len);
    char data;
    i2c.read(address, &data, data_len);
    return data;
}

void L3GD20::writeByte(char reg, char data)
{
    static const int data_len = 2;
    char buf[data_len];
    buf[0] = reg;
    buf[1] = data;
    i2c.write(address, buf, data_len);
}
