#include "mbed.h"
#include "SDFileSystem.h"
#include "RTC8564.h"
#include "AQM0802A.h"
#include "string.h"

Ticker Ticker1;

Serial pc(USBTX, USBRX);
I2C i2c(p9, p10);


//Serial sio(p9, p10);
Serial sio(p28, p27);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
DigitalOut beep(p15);


char year, month, day, week;
char hour, minute, sec;
char lastsec;
char week_chr[7][4] = {"Sun","Mon","Tue","Wed","Thu","Fri","Sat"};
Timer timer;
//DigitalIn button(p21, PullUp);
//lpc             sdi
//                  sdo
//                      sck
//                            cs
SDFileSystem sd(p5, p6, p7, p8, "sd");

//
//SDFileSystem sd(PA_7, PA_6, PA_5, PA_4, "sd");
//SDFileSystem sd(PB_5, PB_4, PB_3, PA_4, "sd");
//SDFileSystem sd(PA_7, PA_6, PA_5, PA_4, "sd");

int index=0;
char buffer[128];
char sdatetime[32];//2016/05/26 hh:nn:ss
char sdate[7];//yymmdd
char stime[7];//hhnnss
int redirect=0;

void TimePrintLCD(void)
{
    year = rtc_read(YEARS);
    month = rtc_read(MONTHS);
    day = rtc_read(DAYS);
    week = rtc_read(WEEKDAYS);
    hour = rtc_read(HOURS);
    minute = rtc_read(MINUTES);
    sec = rtc_read(SECONDS);
    /*
        pc.printf("20%c%c/%c%c/%c%c %s\n",
                  ((year >> 4) & 0x03) + 0x30, (year & 0x0F) + 0x30,
                  ((month >> 4) & 0x01) + 0x30, (month & 0x0F) + 0x30,
                  ((day >> 4) & 0x03)+ 0x30, (day & 0x0F) + 0x30,
                  week_chr[week & 0x07]);
    */
    sdate[0] = ((year >> 4) & 0x03) + 0x30;
    sdate[1] = (year & 0x0F) + 0x30;
    sdate[2] = ((month >> 4) & 0x01) + 0x30;
    sdate[3] = (month & 0x0F) + 0x30;
    sdate[4] = ((day >> 4) & 0x03)+ 0x30;
    sdate[5] = (day & 0x0F) + 0x30;
    sdate[6] = 0;
    lcd_setCursor(0, 0);
    lcd_printStr(sdate);
    /*
        pc.printf("%c%c:%c%c:%c%c\n",
                  ((hour >> 4) & 0x03) + 0x30, (hour & 0x0F) + 0x30,
                  (minute >> 4) + 0x30, (minute & 0x0F) + 0x30,
                  (sec >> 4) + 0x30, (sec & 0x0F) + 0x30 );
    */
    stime[0] = ((hour >> 4) & 0x03) + 0x30;
    stime[1] = (hour & 0x0F) + 0x30;
    stime[2] = (minute >> 4) + 0x30;
    stime[3] = (minute & 0x0F) + 0x30;
    stime[4] = (sec >> 4) + 0x30;
    stime[5] = (sec & 0x0F) + 0x30;
    stime[6] = 0;

    lcd_setCursor(0, 1);
    lcd_printStr(stime);

    sdatetime[0] = '2';
    sdatetime[1] = '0';
    sdatetime[2] = sdate[0];
    sdatetime[3] = sdate[1];
    sdatetime[4] = '/';
    sdatetime[5] = sdate[2];
    sdatetime[6] = sdate[3];
    sdatetime[7] = '/';
    sdatetime[8] = sdate[4];
    sdatetime[9] = sdate[5];
    sdatetime[10] = ' ';

    sdatetime[11] = stime[0];
    sdatetime[12] = stime[1];
    sdatetime[13] = '/';
    sdatetime[14] = stime[2];
    sdatetime[15] = stime[3];
    sdatetime[16] = '/';
    sdatetime[17] = stime[4];
    sdatetime[18] = stime[5];
    sdatetime[19] = 0;
}

void WriteDat(void)
{

    char sf[64];
    strcpy(sf, sdate);
    strcat(sf,".csv");
    //FileHandle* file = sd.open(sf, O_WRONLY | O_CREAT | O_TRUNC);
    FileHandle* file = sd.open(sf, O_WRONLY | O_CREAT | O_APPEND);
    pc.printf("[%s]\n", sf);

    strcpy(sf, sdatetime);
    strcat(sf,", ");
    strcat(sf,"999");
    strcat(sf,"\r\n");
    pc.printf("[%s]\n", sf);
    if (file != NULL) {
        if (file->write(sf, strlen(sf)) != strlen(sf)) {
            pc.printf("write error!\n");
        }
    }
    file->close();
}


void SDCardTest()
{
    //Make sure a card is present
    if (!sd.card_present()) {
        pc.printf("\nNo card present!\n");
        return;
    }

    //Try to mount the SD card
    pc.printf("\nMounting SD card...");
    if (sd.mount() != 0) {
        pc.printf("failed!\n");
        return;
    }
    pc.printf("success!\n");
    //Display the card type
    pc.printf("\tCard type: ");
    SDFileSystem::CardType cardType = sd.card_type();
    if (cardType == SDFileSystem::CARD_NONE)
        pc.printf("None\n");
    else if (cardType == SDFileSystem::CARD_MMC)
        pc.printf("MMC\n");
    else if (cardType == SDFileSystem::CARD_SD)
        pc.printf("SD\n");
    else if (cardType == SDFileSystem::CARD_SDHC)
        pc.printf("SDHC\n");
    else
        pc.printf("Unknown\n");
    //Display the card capacity
    pc.printf("\tSectors: %u\n", sd.disk_sectors());
    pc.printf("\tCapacity: %.1fMB\n", sd.disk_sectors() / 2048.0);
}

void cmd(char *scmd)
{
    pc.printf("[%s]\n", scmd);
    switch (scmd[0]) {
        case 'b':
        case 'B'://b1
            if(strlen(scmd)> 1) {
                if(scmd[1]=='1') {
                    beep=1;
                    led4 = 1;
                } else {
                    led4 = 0;
                    beep=0;
                }
            }
            break;
        case 'W':
        case 'w'://
            WriteDat();
            break;
            
        case 'r':
        case 'R'://
            led3=1;
            redirect=1;
            break;

        case '0':
            led4 = 0;
            beep=0;
            led3=0;
            redirect=0;
            break;

        case 't':
        case 'T'://T 20170516xxxxxx
            if(strlen(scmd)> 8) {
                rtc_setdaytime(&scmd[4], &scmd[6], &scmd[8], &scmd[10], &scmd[12], &scmd[14], "0");
            }
            TimePrintLCD();
            pc.printf("%s %s\n", sdate, stime);
            break;
    }
}

void Int1Sec()
{
    led4 = !led4;
    sec = rtc_read(SECONDS);
    if(lastsec == sec) return;
    lastsec = sec;

    TimePrintLCD();
    if(sec==0) {
        WriteDat();
    }
}

int main()
{
    BusOut leds(LED1, LED2);
    beep=0;

    led1 = 0;
    led2 = 0;
    led3 = 0;
    led4 = 0;
    pc.baud(115200);
    pc.printf("\nStart\n");
    led1 = 1;

    //sio
    sio.baud(115200);
    //sio.printf("\nStart\n");
    //Configure CRC, large frames, and write validation

    //rtc
    sec = rtc_read(SECONDS);
    pc.printf("sec:[%x]\n", sec);
    if(sec > 59) {
        pc.printf("set!\n");
        rtc_setdaytime("17", "01", "01", "00", "00", "00", "6");
    }
    //sd
    sd.crc(true);
    sd.large_frames(true);
    sd.write_validation(true);

    //lcd
    lcd_init();
    setContrast(35);
    lcd_setCursor(0, 0);
    lcd_printStr("SATO");
    lcd_setCursor(0, 1);
    lcd_printStr("SEI");

    Ticker1.attach(&Int1Sec, 0.8);

    index = 0;
    //for(int i=0; i<1; i++){
    while(true) {
        if(sio.readable() && redirect) {
            pc.putc(sio.getc());
        }
        if(pc.readable()) {
            char c = pc.getc();
            pc.printf("%c", c);
            led2 = !led2;
            switch (c) {
                case '\r':
                case '\n':
                    cmd(buffer);
                    index=0;
                    break;

                default:
                    buffer[index] = c;
                    if(index<32)index++;
            }
        }
    }
}

