#include "mbed.h"
#include "TB6612FNG.h"

TB6612FNG::TB6612FNG(PinName IN1, PinName IN2, PinName STBY, PinName PWM):
    _IN1(IN1), _IN2(IN2), _STBY(STBY), _PWM(PWM)
{
    _PWM = 0;
}

void TB6612FNG::STBY(bool f)
{
    _STBY = f;
}

void TB6612FNG::SetW(float W)
{   
    if(0 <= W && W <= 1) _PWM = W;
    else if(1 < W) _PWM = 1;
    else _PWM = 0;
    
}

void TB6612FNG::Forward()
{
    _IN1 = 1;
    _IN2 = 0;
}

void TB6612FNG::Stop()
{
    _IN1 = 0;
    _IN2 = 0;
}

/*
void TB6612FNG::Reverse(byte rpm);
void TB6612FNG::Stop(byte rpm);
void TB6612FNG::Brake(byte rpm);
*/


