#include "mbed.h"
#include "XNucleoIKS01A2.h"

/* Instantiate the expansion board */
static XNucleoIKS01A2 *mems_expansion_board = XNucleoIKS01A2::instance(D14, D15, D4, D5);

/* Retrieve the composing elements of the expansion board */
static LSM6DSLSensor *acc_gyro = mems_expansion_board->acc_gyro;
static LSM303AGRMagSensor *magnetometer = mems_expansion_board->magnetometer;

InterruptIn mybutton(USER_BUTTON);
DigitalOut myled(LED1);

volatile int mems_event = 0;
volatile int mems_event1 = 0;
volatile int step_count_reset_request = 0;
uint32_t previous_tick = 0;
uint32_t current_tick = 0;
uint16_t step_count = 0;

/* User button callback. */
void pressed_cb() {
  step_count_reset_request = 1;
}

/* Interrupt 1 callback. */
void int1_cb() {
  mems_event = 1;
}

/* Interrupt 1 callback. */
void int2_cb() {
  mems_event1 = 1;
}

/* Print the orientation. */
void send_orientation() {
  uint8_t xl = 0;
  uint8_t xh = 0;
  uint8_t yl = 0;
  uint8_t yh = 0;
  uint8_t zl = 0;
  uint8_t zh = 0;
  
  acc_gyro->get_6d_orientation_xl(&xl);
  acc_gyro->get_6d_orientation_xh(&xh);
  acc_gyro->get_6d_orientation_yl(&yl);
  acc_gyro->get_6d_orientation_yh(&yh);
  acc_gyro->get_6d_orientation_zl(&zl);
  acc_gyro->get_6d_orientation_zh(&zh);
  
  if ( xl == 0 && yl == 0 && zl == 0 && xh == 0 && yh == 1 && zh == 0 ) {
    printf( "\r\n  ________________  " \
            "\r\n |                | " \
            "\r\n |  *             | " \
            "\r\n |                | " \
            "\r\n |                | " \
            "\r\n |                | " \
            "\r\n |                | " \
            "\r\n |________________| \r\n" );
  }

  else if ( xl == 1 && yl == 0 && zl == 0 && xh == 0 && yh == 0 && zh == 0 ) {
    printf( "\r\n  ________________  " \
            "\r\n |                | " \
            "\r\n |             *  | " \
            "\r\n |                | " \
            "\r\n |                | " \
            "\r\n |                | " \
            "\r\n |                | " \
            "\r\n |________________| \r\n" );
  }
  
  else if ( xl == 0 && yl == 0 && zl == 0 && xh == 1 && yh == 0 && zh == 0 ) {
    printf( "\r\n  ________________  " \
            "\r\n |                | " \
            "\r\n |                | " \
            "\r\n |                | " \
            "\r\n |                | " \
            "\r\n |                | " \
            "\r\n |  *             | " \
            "\r\n |________________| \r\n" );
            
            
            
  }
  
  else if ( xl == 0 && yl == 1 && zl == 0 && xh == 0 && yh == 0 && zh == 0 ) {
    printf( "\r\n  ________________  " \
            "\r\n |                | " \
            "\r\n |                | " \
            "\r\n |                | " \
            "\r\n |                | " \
            "\r\n |                | " \
            "\r\n |             *  | " \
            "\r\n |________________| \r\n" );
  }
  
  else if ( xl == 0 && yl == 0 && zl == 0 && xh == 0 && yh == 0 && zh == 1 ) {
    printf( "\r\n  __*_____________  " \
            "\r\n |________________| \r\n" );
  }
  
  else if ( xl == 0 && yl == 0 && zl == 1 && xh == 0 && yh == 0 && zh == 0 ) {
    printf( "\r\n  ________________  " \
            "\r\n |________________| " \
            "\r\n    *               \r\n" );
  }
  
  else {
    printf( "None of the 6D orientation axes is set in LSM6DSL - accelerometer.\r\n" );
  }
}

int main() {
      uint8_t id;
        int32_t axes[3];
    /* Attach callback to User button press */
  mybutton.fall(&pressed_cb);
  
  /* Attach callback to LSM6DSL INT1 */
  acc_gyro->attach_int1_irq(&int1_cb);
  
  acc_gyro->enable_int1_irq();
  
    /* Attach callback to LSM6DSL INT1 */
  acc_gyro->attach_int2_irq(&int2_cb);
  
  
  acc_gyro->enable_int2_irq();

  /* Enable LSM6DSL accelerometer */
  acc_gyro->enable_x();
  /* Enable 6D Orientation. */
  acc_gyro->enable_6d_orientation();
  
  /* Enable Free Fall Detection. */
  acc_gyro->enable_free_fall_detection(LSM6DSL_INT2_PIN);  
  
    /* Enable Pedometer. */
  acc_gyro->enable_pedometer();
  
/* Enable Tilt Detection. */
  acc_gyro->enable_tilt_detection();
  
  magnetometer->enable();
  
  previous_tick = clock();
  
  printf("\r\n--- Starting new run ---\r\n");
  
  magnetometer->read_id(&id);
  printf("LSM303AGR magnetometer            = 0x%X\r\n", id);
 
  while(1) {
    
    if (mems_event) 
    {
      mems_event = 0;
      LSM6DSL_Event_Status_t status;
      acc_gyro->get_event_status(&status);
      if (status.D6DOrientationStatus) {
        /* Send 6D Orientation */
        send_orientation();
        
        /* Led blinking. */
       // myled = 1;
        //wait(0.2);
       // myled = 0;
  
        
      }

      
      
      acc_gyro->get_event_status(&status);
        if (status.StepStatus) {
        /* New step detected, so print the step counter */
        acc_gyro->get_step_counter(&step_count);
        printf("Step counter: %d\r\n", step_count);
      
        /* Led blinking. */
        //myled = 1;
        //wait(0.1);
      //  myled = 0;
      }
      acc_gyro->get_event_status(&status);
        if (status.TiltStatus) {
        /* Led blinking. */
        //myled = 1;
        //wait(0.2);
       // myled = 0;

        /* Output data. */
        printf("Tilt Detected!\r\n");
      }    
    }
    
    if(step_count_reset_request) {
      step_count_reset_request = 0;
      acc_gyro->reset_step_counter();
    }
    
    
     if (mems_event1) 
    {   
       mems_event1 = 0;
      LSM6DSL_Event_Status_t status;   
    
        acc_gyro->get_event_status(&status);
        if (status.FreeFallStatus) {
        /* Led blinking. */
        myled = 1;
        wait(0.2);
        myled = 0;

        /* Output data. */
        printf("Free Fall Detected!\r\n");
      }
      
      
    magnetometer->get_m_axes(axes);
    printf("LSM303AGR [mag/mgauss]:  %6ld, %6ld, %6ld\r\n", axes[0], axes[1], axes[2]);
  /*  //Algo 1 - Please fill the values. 
    if((axes[0] > fill_the_value) &&  (axes[0] < fill_the_value) &&
       (axes[1] > fill_the_value) &&  (axes[1] < fill_the_value) &&
       (axes[2] > fill_the_value) &&  (axes[2] < fill_the_value)) 
        {
            printf("Board is tilted on the Left side!\r\n");
        }  
        else 
        {
            printf("Board is tilted on the Right side\n\r");
            
        } */
        
    //Condition for right tilt check            
    if (axes[1] <= -350)
        printf("Message: Board is tilted on the Left side\n\r");
    
    //Condition for right tilt check
    if (axes[1] >= -180)
        printf("Message: Board is tilted on the Right side\n\r");
           
    wait(0.5); 
        
    }

    
  }
}
