/** LSM303D Interface Library
 *
 * base on code by Michael Shimniok http://bot-thoughts.com
 *
 *  and on test program by @tosihisa and 
 *
 *  and on Pololu sample library for LSM303D breakout by ryantm:
 *
 *  ported by Brian Claus
 *
 * Copyright (c) 2011 Pololu Corporation. For more information, see
 *
 * http://www.pololu.com/
 * http://forum.pololu.com/
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */
#include "mbed.h"
#include "LSM303D.h"

const int addr_acc_mag = 0x3A;

enum REG_ADDRS {
    /* --- Mag --- */
    OUT_X_M     = 0x08,
    OUT_Y_M     = 0x0A,
    OUT_Z_M     = 0x0C,
    /* --- Acc --- */
    OUT_X_A     = 0x28,
    OUT_Y_A     = 0x2A,
    OUT_Z_A     = 0x2C,
    //
    CTRL0       = 0x1F,
    CTRL1       = 0x20,
    CTRL2       = 0x21,
    CTRL3       = 0x22,
    CTRL4       = 0x23,
    CTRL5       = 0x24,
    CTRL6       = 0x25,
    CTRL7       = 0x26
};

bool LSM303D::write_reg(int addr_i2c,int addr_reg, char v)
{
    char data[2] = {addr_reg, v}; 
    return LSM303D::_LSM303.write(addr_i2c, data, 2) == 0;
}

bool LSM303D::read_reg(int addr_i2c,int addr_reg, char *v)
{
    char data = addr_reg; 
    bool result = false;
    
    __disable_irq();
    if ((_LSM303.write(addr_i2c, &data, 1) == 0) && (_LSM303.read(addr_i2c, &data, 1) == 0)){
        *v = data;
        result = true;
    }
    __enable_irq();
    return result;
}

LSM303D::LSM303D(PinName sda, PinName scl):
    _LSM303(sda, scl)
{
    char reg_v;
        
    reg_v = 0;
    
    //acc
    reg_v |= 0x57;          /* 50 Hz X/Y/Z axis enable. */
    write_reg(addr_acc_mag,CTRL1,reg_v);

    /* -- mag --- */
    reg_v = 0;
    reg_v |= 0x74;     //M_RES = 11 (high resolution mode); M_ODR = 100 (50 Hz ODR)
    write_reg(addr_acc_mag,CTRL5,reg_v);

 

    reg_v = 0;    
    reg_v |= 0x00;   //continuous mag
    write_reg(addr_acc_mag,CTRL7,reg_v);
    
    reg_v = 0;    
    reg_v |= 0x00;   //+-2gauss
    write_reg(addr_acc_mag,CTRL6,reg_v);
}


bool LSM303D::read(float *aData,float *mData) {
    char acc[6], mag[6];
 
    if (recv(addr_acc_mag, OUT_X_A, acc, 6) && recv(addr_acc_mag, OUT_X_M, mag, 6)) {
        aData[0] = float(short(acc[1] << 8 | acc[0]))*0.061;  //32768/4=8192
        aData[1] =  float(short(acc[3] << 8 | acc[2]))*0.061;
        aData[2] =  float(short(acc[5] << 8 | acc[4]))*0.061;
        //+-2gauss
        mData[0] = float(short(mag[1] << 8 | mag[0]))*0.08;
        mData[1] = float(short(mag[3] << 8 | mag[2]))*0.08;
        mData[2] = float(short(mag[5] << 8 | mag[4]))*0.08;
 
        return true;
    }
 
    return false;
}


bool LSM303D::recv(char sad, char sub, char *buf, int length) {
    if (length > 1) sub |= 0x80;
 
    return _LSM303.write(sad, &sub, 1, true) == 0 && _LSM303.read(sad, buf, length) == 0;
}
