/*
説明
Nucleo-F303K8とBMP180を使った気温・気圧・高度計算のサンプルプログラム

ライブラリ
https://developer.mbed.org/users/spiridion/code/BMP180/

以下ピン配置
Nucleo  BMP180
GND-----GND-------0V
+3V3----VIN
D4------SDA
D5------SCL

*/
#include "mbed.h"
#include "math.h"
#include "BMP180.h"
#define p0 1013.25f//海面気圧

DigitalOut led(dp28);
DigitalOut led2(LED2);
DigitalIn flyp(dp1);
DigitalOut cutp1(dp10);
DigitalOut cutp2(dp6);
BMP180  bmp(dp5, dp27);
Serial  dbg(dp16,dp15);
Timer timer;

float getAlt(float press, float temp);

int main() {
    dbg.printf("Hello\r\n");
    cutp1 = 0;
    cutp2 = 0;
    float pressure,temperature,alt_gnd,alt_now;
    float alt[30];
    float time;
    int i = 0;   
    bmp.Initialize(64,BMP180_OSS_ULTRA_LOW_POWER);  //BMP180初期化
    alt_gnd = 0.0;
    int time_cnt = 0;
    //地上高度取得（10回の平均値）
    for(i =0; i < 10; i++){
        bmp.ReadData(&temperature,&pressure);
        alt_gnd = alt_gnd + getAlt(pressure,temperature);
    }
    alt_gnd = alt_gnd/10.0;
    dbg.printf("GND:%f\r\n",alt_gnd);
    led = 1;
    
    //フライトピン抜けてたらエラー
    if(flyp == 0){
        while(1){
            led = !led;
            led2 = !led2;
            wait(0.2);
        }
    }
    dbg.printf("standby\r\n");
    while(flyp == 1);   //フライトピン抜けるまで待つ
    dbg.printf("rerease\r\n");
    timer.start();
    wait(5.0);  //落ち着くまで待つ
    led2 = 1;
    led = 0;
    i = 0;
    
    //高度が50m以下または10分たつ，になるまで着地判定はしない．
    while(1){
         bmp.ReadData(&temperature,&pressure);
         alt_now = getAlt(pressure,temperature);
         dbg.printf("NOW:%f[m]\r\n",alt_now - alt_gnd);
         time = timer.read();
         if(time > 10){
             time_cnt ++;
             timer.reset();
             wait(0.1);
             timer.start();
        }
         if(time_cnt == 1) break;
    }
    dbg.printf("under50m\r\n");
    float land = 0.0;
    int cnt = 0;
    led = 1;
    //30分たつ又は高度変化が1mいない，で着地判定
    while(1) {
        bmp.ReadData(&temperature,&pressure);
        time = timer.read();
        if(time > 10){
             time_cnt ++;
             timer.reset();
             wait(0.1);
             timer.start();
        }
        alt[i] = getAlt(pressure,temperature);
        dbg.printf("alt[%d]:%f",i,alt[i]);
        if(i > 0){
            land = alt[i-1] - alt[i];
            if(land < 0) land = land * (-1);    //-を＋に
            if(land < 1.0) cnt++;   //約1秒前との高度差が1m未満の場合，カウント
        }
        if(i == 30){    //30カウント（約30秒）でカウントリセット
            i = 0;
            cnt = 0;
        }
        dbg.printf("cnt:%d\r\n",cnt);
        if(time_cnt == 2) break; //30カウントのうち10カウント又は30分経過で着地判定
        wait(1.0);
        i ++;
    }
    timer.stop();
    //ニクロム線に10秒ずつ電流流すを繰り返す
    while(1){
        cutp1 = 1;
        led = 0;
        wait(60);
        cutp1 = 0;
        wait(1);
        cutp2 = 1;
        led = 1;
        wait(60);
        led2 = !led2;
        cutp2 = 0;
        wait(1);
        while(flyp == 1){
            dbg.printf("stop\r\n");
            wait(1);
            }
    }
}

float getAlt(float press, float temp){
    return (pow((p0/press), (1.0f/5.257f))-1.0f)*(temp+273.15f)/0.0065f;
}