/* getting the RPC working on the Freedom Boards

Able to initialise the digital classes, but not the analoge functions for this board

A simple wrapper function is provided which sets up an analoge input on PTC2 which can then accessed
by sending /AnIn/run down the serial line.

*/

#include "mbed.h"
#include "mbed_rpc.h"



using namespace mbed;

AnalogIn Ain(PTC2);

Serial pc(USBTX, USBRX);

 
void doSAnalogeIn(Arguments* input, Reply * output );

RPCFunction AnIn(&doSAnalogeIn,"AnIn");



int main() {
    pc.baud(57600);
    // call the static RPC member functions to add classes to the list available
    // these appear to be listed in rpcclasses.h, and are templated
    RPC::add_rpc_class<RpcDigitalIn>();
    RPC::add_rpc_class<RpcDigitalOut>();
    //RPC::add_rpc_class<RpcAnalogIn>();
    //RPC::add_rpc_class<RpcAnalogOut>();
   
    // receive commands, and send back the responses
    char buf[RPC_MAX_STRING], outbuf[RPC_MAX_STRING];
    while(1) {
        pc.gets(buf, RPC_MAX_STRING);
        RPC::call(buf, outbuf); 
        pc.printf("%s\n", outbuf);
    }
 
};

void doSAnalogeIn(Arguments * input, Reply * output)
{
    //custom code to add access to the Analoge ports
    
    output->putData(Ain.read());
};
    

