#include "mbed.h"
#include "FastAnalogIn.h"

/*
Simple program which uses a ticker object to record and analoge value and store it in a cicular buffer.
The ticker delay sets the sampling rate. 

The FastAnalogIn Library is used (http://mbed.org/users/Sissors/code/FastAnalogIn/) to rapidly sample 
a single channel. 

In the main loop a busy loop is used to send read the data from the cicular buffer and send down the serial line


*/

//size of cicular buffer
#define BuffSize 255

using namespace mbed;

FastAnalogIn Ain(PTC2);

Serial pc(USBTX, USBRX);
Timer t;
Ticker tock;

//set the delay used by the ticker
float delay = 0.01;

//some circular buffers

float data[BuffSize];
float time_[BuffSize];
long i =0;
int j=0;
long k =0;
 
void ana()
{
   if(i<k+BuffSize)
    {j = i%BuffSize;
    //time_[j]=t.read();
    data[j]=Ain.read();
    time_[j]=t.read();
    i++;
    }
}


int main()
{
    pc.baud(57600);
    t.start();
    tock.attach(&ana,delay); 
    while (true) {        
       if(k<i)
        {
        pc.printf("%f,%f\n",time_[k%BuffSize],data[k%BuffSize]);
        k++;
        }
        
  
    }
}
