#include "mbed.h"

Serial pc(USBTX, USBRX); // tx, rx
Serial device(p13, p14);  // tx, rx
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
PwmOut IRLED(p21);
//IR send and receive demo
//LED1 and LED2 indicate TX/RX activity
//Character typed in PC terminal application sent out and returned back using IR transmitter and receiver

int main() {
    //IR Transmit code
    IRLED.period(1.0/38000.0);
    IRLED = 0.5;
    //Drive IR LED data pin with 38Khz PWM Carrier
    //Drive IR LED gnd pin with serial TX
    device.baud(2400);
    while(1) {
        if(pc.readable()) {
            myled1 = 1;
            device.putc(pc.getc());
            myled1 = 0;
        }
        //IR Receive code
        if(device.readable()) {
            myled2 = 1;
            pc.putc(device.getc());
            myled2 = 0; 
        }
    }
}