#include "mbed.h"
#include "JoystickPS3.h"
#include "gerakBase.h"

//////////////////////////////////////////
// Variable Library

/////////////////////////////////////////
olahGerak::olahGerak(   PinName _pin_tx, PinName _pin_rx,
                        PinName _pin_pwm_A, PinName _pin_fwd_A, PinName _pin_rev_A,
                        PinName _pin_pwm_B, PinName _pin_fwd_B, PinName _pin_rev_B,
                        PinName _pin_pwm_C, PinName _pin_fwd_C, PinName _pin_rev_C):
                joysticknucleo joystick(PIN_TX, PIN_RX);
                gerakBase Base(
                            _pin_pwm_A, _pin_fwd_A, _pin_rev_A, // Motor A
                            _pin_pwm_B, _pin_fwd_B, _pin_rev_B, // Motor B
                            _pin_pwm_C, _pin_fwd_C, _pin_rev_C);// Motor C
    {
    }

void olahgerak::inisiasiJoystick(){
    joystick.setup();
    joystick.idle();
}
void olahGerak::bacaOlahData(){
    if(joystick.readable() ) {
        // Panggil fungsi pembacaan joystik
        joystick.baca_data();
    }
    joystick.olah_data();
}

int olahGerak::caseGerak(){
{
    int _case_gerak;
     if (!joystick.L1 && joystick.R1) {
        // Pivot Kanan
        _case_gerak = 1;
    } else if (!joystick.R1 && joystick.L1) {
        // Pivot Kiri
        _case_gerak = 2;
    } else if ((!joystick.R1)&&(!joystick.L1)&&(joystick.atas)&&(!joystick.bawah)&&(!joystick.kanan)&&(!joystick.kiri)) {  
        // Maju
        _case_gerak = 3;
    } else if ((!joystick.R1)&&(!joystick.L1)&&(!joystick.atas)&&(joystick.bawah)&&(!joystick.kanan)&&(!joystick.kiri))  {  
        // Mundur
        _case_gerak = 4;
    } else if ((!joystick.R1)&&(!joystick.L1)&&(joystick.atas)&&(!joystick.bawah)&&(!joystick.kiri)&&(joystick.kanan))   {   
        // Serong Atas Kanan
        _case_gerak = 5;
    } else if((!joystick.R1)&&(!joystick.L1)&&(!joystick.atas)&&(joystick.bawah)&&(!joystick.kiri)&&(joystick.kanan)) {   
        // Serong Bawah Kanan
        _case_gerak = 6;
    } else if ((!joystick.R1)&&(!joystick.L1)&&(joystick.atas)&&(!joystick.bawah)&&(joystick.kiri)&&(!joystick.kanan)) {   
        // Serong Atas Kiri
        _case_gerak = 7;
    } else if ((!joystick.R1)&&(!joystick.L1)&&(!joystick.atas)&&(joystick.bawah)&&(joystick.kiri)&&(!joystick.kanan)) {   
        // Serong Bawah Kiri
        _case_gerak = 8;
    } else if ((!joystick.R1)&&(!joystick.L1)&&(!joystick.atas)&&(!joystick.bawah)&&(joystick.kanan)&&(!joystick.kiri))  {   
        // Kanan
        _case_gerak = 9;
    } else if ((!joystick.R1)&&(!joystick.L1)&&(!joystick.atas)&&(!joystick.bawah)&&(!joystick.kanan)&&(joystick.kiri)) {   
        // Kiri
        _case_gerak = 10;        
    } else if ((joystick.silang)&&(!joystick.kotak)&&(!joystick.segitiga)&&(!joystick.lingkaran)&&(!joystick.atas)&&(!joystick.bawah)&&(!joystick.kanan)&&(!joystick.kiri)) {
        // Brake
        _case_gerak = 11; 
    } else Base.rem(1);
    
    return(_case_gerak);
}

void olahGerak::gerakAktuator(_case_gerak){
     if (_case_gerak == 1){
            Base.pivotKanan(0.4);
            
        }
        else if (_case_gerak == 2){
                 Base.pivotKiri(0.4);
        }
        else if (_case_gerak == 3){
                 Base.maju(0.35);
                 
        }
        else if (_case_gerak == 4){
                 Base.mundur(0.35);
                 
        }
        else if (_case_gerak == 9){
                 Base.kanan(0.5);
                 
        }
        else if (_case_gerak == 10){
                 Base.kiri(0.5);
                 
        }
        else if (_case_gerak == 11){
                 Base.rem(1);
        } 
}