#include "mbed.h"
#include "kontrolPID.h"
 float _kP, _kI, _kD;
 int _interval;
 short _limit_Min, _limit_Max;
 float _current_Error, _sum_Error, _delta_Error, _previous_Error;
 float _controller_Output;
kontrolPID::kontrolPID(float kP, float kI, float kD,
                        int interval, 
                        short limit_Min, short limit_Max){
    _kP = kP;
    _kI = kI;
    _kD = kD;
    _interval = interval;
    _limit_Min = limit_Min;
    _limit_Max = limit_Max;
}
 
void kontrolPID::resetPID(){
    _current_Error = 0;
    _delta_Error = 0;
    _sum_Error = 0;
}
 
float kontrolPID::hitungPID(float _process_Value, float _set_Point){
    _current_Error = _set_Point - _process_Value;
    _delta_Error = _current_Error - _previous_Error;
    _sum_Error = _current_Error + _previous_Error;
    
    _controller_Output = _kP * _current_Error + _kI * _sum_Error * _interval + _kD * _delta_Error / _interval;
    
    if (_limit_Max < _controller_Output){
        _controller_Output = _limit_Max;
    }
    else if (_limit_Min > _controller_Output){
        _controller_Output = _limit_Min;
    }
    
    _previous_Error = _current_Error;
    
    return _controller_Output;
}
        