#include <mbed.h>
#include <time.h>
#include <string>
#include <stdlib.h> 
#include <cstdio>
#include <cstdlib>
#include <alloca.h>
#include <cyassl/asn.h>
#include <cyassl/ctc_rsa.h>

Serial pc(USBTX, USBRX); // tx, rx
 
int main() {
    clock_t t_ini, t_fin;
    double secs;  
    RsaKey genKey;
    RNG rng;
    InitRng(&rng);  
    for (int i=0; i<30;i++){ 
        t_ini = clock();       
        InitRsaKey(&genKey, 0); 
        MakeRsaKey(&genKey, 512, 65537, &rng);
        FreeRsaKey(&genKey);
        t_fin = clock();
        secs = (double)(t_fin - t_ini) / CLOCKS_PER_SEC;
        pc.printf("%.16g\n", secs * 1000.0);
    }  
}