#include <mbed.h>
#include <time.h>
#include <string>
#include <stdlib.h> 
#include <cstdio>
#include <cstdlib>
#include <alloca.h>
#include "sha256.h"
#include "ecc.h"
#include "ctc_rsa.h"

Serial pc(USBTX, USBRX); // tx, rx

void vli_print(uint32_t *p_vli, unsigned int p_size)
{
    while(p_size)
    {
        printf("%08X ", (unsigned)p_vli[p_size - 1]);
        --p_size;
    }
}

int rsa_test()
{
        RsaKey genKey;
        InitRsaKey(&genKey, 0);
        for (int i=0; i<100;i++){
            pc.printf("%d ", genKey.p.dp[i]);
            }
            RsaKey* key;
            RNG* rng;
            InitRng(rng);
        MakeRsaKey(key, 512, 65537, rng);
    return 0;
}


int main() {
    clock_t t_ini, t_fin;
  double secs;

  
    /*GENERACION DE CLAVES*/
    pc.printf("Hola soy Alice, voy a generar mi clave publica coordenada x \n");
    uint32_t l_private1[NUM_ECC_DIGITS];//clave privada
    uint32_t aleat[NUM_ECC_DIGITS];  //aleatorio
    for (int i=0; i<NUM_ECC_DIGITS;i++){
          aleat[i]=rand()%10;  //entero entre 0-9
    }
    
    EccPoint l_public1;
t_ini = clock();
    ecc_make_key(&l_public1, l_private1, aleat);  //Calcula la publica
t_fin = clock();
    pc.printf("%08X ", (unsigned)l_public1.x);  //imprime coordenada x de la clave publica
    pc.printf("Hola soy Alice, voy a generar mi clave publica coordenada y \n");
    pc.printf("%08X ", (unsigned)l_public1.y);  //imprime coordenada y de la clave publica
    
    uint32_t l_private2[NUM_ECC_DIGITS];  //aleatoria
    EccPoint l_public2;
    ecc_make_key(&l_public2, l_private2, aleat);  //Calcula la publica
    pc.printf("Hola soy Bob, voy a generar mi clave publica coordenada x \n");
    pc.printf("%08X ", (unsigned)l_public2.x);  //imprime coordenada x de la clave publica
    pc.printf("Hola soy Bob, voy a generar mi clave publica coordenada y \n");
    pc.printf("%08X ", (unsigned)l_public2.y);  //imprime coordenada y de la clave publica
    
    /*D-H*/
    uint32_t l_shared1[NUM_ECC_DIGITS];
    uint32_t l_shared2[NUM_ECC_DIGITS];
    uint32_t l_random1[NUM_ECC_DIGITS];
    uint32_t l_random2[NUM_ECC_DIGITS];
    
    //comprobamos que se ha generado bien la clave compartida y que tienen la misma
    if(!ecdh_shared_secret(l_shared1, &l_public1, l_private2, l_random1)) 
        {
        pc.printf("shared_secret() failed (1)\n");
            return 1;
        }

        if(!ecdh_shared_secret(l_shared2, &l_public2, l_private1, l_random2))
        {
            pc.printf("shared_secret() failed (2)\n");
            return 1;
        }
        
        if(memcmp(l_shared1, l_shared2, sizeof(l_shared1)) != 0)
        {
            pc.printf("Shared secrets are not identical!\n");
            pc.printf("Shared secret 1 = ");
            vli_print(l_shared1, NUM_ECC_DIGITS);
            pc.printf("\n");
            pc.printf("Shared secret 2 = ");
            vli_print(l_shared2, NUM_ECC_DIGITS);
            pc.printf("\n");
            pc.printf("Private key 1 = ");
            vli_print(l_private1, NUM_ECC_DIGITS);
            pc.printf("\n");
            pc.printf("Private key 2 = ");
            vli_print(l_private2, NUM_ECC_DIGITS);
            pc.printf("\n");
        }else {
            pc.printf("Shared secrets are identical!\n");
        }
        
        /*FIRMA y VERIFICACION*/
        
    string mensaje = "Hola";
    
    //SHA-256 y paso a uint32//
    string output1 = sha256(mensaje);
    uint32_t hash[NUM_ECC_DIGITS];
    
    int j=0;
    while (j<NUM_ECC_DIGITS){
        string cortada=output1.substr(8*j, 7);
        //pc.printf("corte: %s ", cortada); 
        const char* caracteres=cortada.c_str();
        uint32_t x = strtoul(caracteres, NULL, 16);
        //pc.printf("hash: %08X ", (unsigned)x); 
        hash[j]=x;
        j++;
    }
    ///--------///
    uint32_t aleatorio[NUM_ECC_DIGITS];  
    for (int i=0; i<NUM_ECC_DIGITS;i++){
          aleatorio[i]=rand()%10;  //entero entre 0-9
    }
    uint32_t r[NUM_ECC_DIGITS];
    uint32_t s[NUM_ECC_DIGITS];
    
    if(!ecdsa_sign(r, s, l_private1, aleatorio, hash))
        {
            pc.printf("ecdsa_sign() failed\n");
        }
        
        if(!ecc_valid_public_key(&l_public1))
        {
            pc.printf("Not a valid public key!\n");
        }
        
        if(!ecdsa_verify(&l_public1, hash, r, s))
        {
            pc.printf("ecdsa_verify() failed\n");
        }else{
            pc.printf("ecdsa_verify() correcto \n");
        }
   

  secs = (double)(t_fin - t_ini) / CLOCKS_PER_SEC;
   pc.printf("%.16g milisegundos\n", secs * 1000.0);
   
   rsa_test();
    
}

