#include "mbed.h"
#include "C12832.h"

// Max X value of LCD screen
#define MAX_X 124
// Max Y value of LCD screen
#define MAX_Y 28

struct ball_t {
    int y;
    int x;
};
ball_t ball; // Keep track of ball's x and y
C12832 lcd(D11, D13, D12, D7, D10);

// Joystick Pins
DigitalIn up(A2);
DigitalIn down(A3);
DigitalIn left(A4);
DigitalIn right(A5);
DigitalIn fire(D4);

void draw_ball() {
    // Clear LCD
    lcd.cls();
    // Calculate ball's position based on joystick movement
    if(left){
        ball.x = ball.x > 0 ? ball.x-1 : MAX_X;
    }
    if(right) {
        ball.x = ball.x < MAX_X ? ball.x+1 : 0;
    }
    if(up) {
        ball.y = ball.y > 0 ? ball.y-1 : MAX_Y;
    }
    if(down) {
        ball.y = ball.y < MAX_Y ? ball.y+1 : 0;
    }
    if(fire){
        // Increment ball's x position by 10
        ball.x = ball.x < MAX_X-10 ? ball.x+10 : 10-(MAX_X-ball.x);
    }
    
    lcd.fillcircle(ball.x, ball.y, 3, 1);
}

int main()
{
    // Put the ball in the middle of the screen initially
    ball.x = MAX_X/2;
    ball.y = MAX_Y/2;
    
    EventQueue queue;
    // Update the ball's position every 50 ms
    queue.call_every(50, draw_ball);
    queue.dispatch();
}


