#include "Blinky.h"
#include "mbed.h"
#include "greentea-client/test_env.h"
#include "unity.h"
#include "utest.h"
#include "rtos.h"
 
using namespace utest::v1;
 
//All tests will blink the LED 5 times
const int expected_blinks = 5;
//To be set by interrupt handler
int measured_blinks = 0;
 
//To be called by interrupt, increases the number of measured rising edges 
void count_blinks(){
        TEST_ASSERT_MESSAGE(++measured_blinks<=expected_blinks, "******Too many blinks!******");
}
 
//Generic blink test
//interval => the the amount of time between blinks
//led => PinName of LED to blink
bool test_blinks(int interval, PinName led){
    //reset the measured blinks to 0 for each case
    measured_blinks = 0;
    //Set an appropriate wait time to measure exactly expected_blinks
    //with the given interval 
    float wait_time = 2*interval*expected_blinks;
    //Create an interrupt that calls count_blinks on rising edge of LED pin
    InterruptIn blink_counter(led);
    //Create Blinky
    Blinky blinker(led, interval);
    //Attach interrupt
    blink_counter.rise(&count_blinks);
    //start blinky
    blinker.start();
    //Wait the appropriate amount of time for expected_blinks 
    Thread::wait(wait_time);
    blinker.stop();
}
 
void blink_500(){
    //Blinky with a 500 ms interval between blinks
    test_blinks(500, LED1);
}
void blink_1000(){
    //Blinky with a 1000 ms interval between blinks
    test_blinks(1000, LED1);
}
 
utest::v1::status_t test_setup(const size_t number_of_cases) {
    // Setup Greentea using a reasonable timeout in seconds
    GREENTEA_SETUP(40, "default_auto");
    return verbose_test_setup_handler(number_of_cases);
}
 
// Test cases
Case cases[] = {
    Case("Testing 500 ms interval", blink_500),
    Case("Testing 1000 ms interval", blink_1000),
};
 
Specification specification(test_setup, cases);
 
// Entry point into the tests
int main() {
    return !Harness::run(specification);
}