#include "mbed.h"

// Labs 2: Example program for polling an input
// --------------------------------------------
// The program uses a thread to poll a digital input
//   - The thread monitors the position of the button
//   - When the button transitions up and down, a press event is signaled 
//   - Button bounce is guarded against
// A second thread (the default one) checks for the press event and toggles the LED

DigitalIn b1(PTD0, PullUp);//defining button config
DigitalOut led(LED1);//output


Thread pollT ; //thread to poll (thread called poll)
volatile int pressEvent = 0 ;  // Variabe set by the polling thread
  // Sharing a global variable between two threads is not safe in general
  //  but it can be ok if a) update is atomic and b) only one thread writes

enum buttonPos { up, down, bounce }; // Button positions
void polling() {
    buttonPos pos = up ;
    int bcounter = 0 ;
    while (true) {
        ThisThread::sleep_for(30) ; // poll every 30ms
        switch (pos) {
            case up :
                if (!b1.read()) {    // now down 
                    pressEvent = 1 ;  // transition occurred
                    led=!led;
                    pos = down ;
                }
                break ;
            case down : 
                if (b1 == 1) { // no longer down
                    bcounter = 3 ; // wait four cycles
                    pos = bounce ;
                }
                break ;
            case bounce :
                if (b1 == 0) { // down again - button has bounced
                    pos = down ;   // no event
                } else if (bcounter == 0) {
                    pos = up ;     // delay passed - reset to up
                } else {
                    bcounter-- ;   // continue waiting
                }
                break ;
        }
    }
}

/*  ---- Main function (default thread) ----
    Note that if this thread completes, nothing else works
 */
int main() {
    led = 1 ;  // Initially off
    pollT.start(callback(polling));
    int p[5]={2,4, 6, 8, 10};
    int counter = 0;
    int i=0;
    while(true) {
    if (pressEvent) {
            pressEvent = 0 ; // clear the event variable
            counter++;
            if (counter > 4 ){
                counter = 0;
                }
            
        }
        if (i>p[counter]) { 
        i = 0; 
        led=!led;
        }
        ThisThread::sleep_for(100) ; // delay for 100ms 
        i++;
    }
}