
// LAB 3 SAMPLE PROGRAM 1
//   Revised for mbed 5 
//   Revised to replace Ticker with event queue and thread

#include "mbed.h"

InterruptIn button(PTD0);
AnalogIn ain(A0);          // Analog input
DigitalOut led1(D2);  
DigitalOut led2(D3); 
DigitalOut led3(D4); 
DigitalOut led4(D5); 
DigitalOut led5(D6);   // Red LED
EventQueue queue; 
volatile int pressEvent = 0 ;
  // creates an event queue, to call read ADC
 

Serial pc(USBTX, USBRX); // tx, rx, for debugging

// This thread runs the event queue
Thread eventThread ;
//Thread pollT ; // thread to poll
 // Variabe set by the polling thread
  // Sharing a global variable between two threads is not safe in general
  //  but it can be ok if a) update is atomic and b) only one thread writes



// Message type
typedef struct {
  uint16_t analog; /* Analog input value */
} message_t;

// Mail box
Mail<message_t, 2> mailbox;

// Function called every 10ms to read ADC
// Average using a low pass filter  
// Every 10th value is sent to mailbox
volatile int samples = 0 ;
volatile uint16_t smoothed = 0 ; 

void readA0() {
    smoothed = (smoothed >> 1) + (ain.read_u16() >> 1) ;
    samples++ ;
    if (samples == 10) {
        // send to thread
        message_t *mess = mailbox.alloc() ; // may fail but does not block
        if (mess) {
            mess->analog = smoothed ;
            mailbox.put(mess); // fails but does not block if full
                }
        samples = 0;
    }
}

// Write voltage digits
//   v  Voltage as scale int, e.g. 3.30 is 330
void vToString(int v, char* s) {    
    s[3] = '0' + (v % 10) ;
    v = v / 10 ;
    s[2] = '0' + (v % 10) ;
    v = v / 10 ;
    s[0] = '0' + (v % 10) ;
}
void buttonCallback(){
    pressEvent = 1 ;  
} 
// Main program
//   Initialise variables
//   Attach ISR for ticker
//   Procss messages from mailbox  
 


int main() {
    button.mode(PullUp);             // Ensure button i/p has pull up
    button.fall(&buttonCallback) ;   // Attach function to falling edge
    int volts = 0 ;
    //const int threshold = 100 ;
    int maxvolt=330;
    int counter = 0 ;
    char vstring[] = "X.XX\r\n" ;
    
    // Start the event queue
    eventThread.start(callback(&queue, &EventQueue::dispatch_forever));
    //pollT.start(callback(polling));
    // call the readA0 function every 10ms 
    queue.call_every(10, readA0) ; 
    //ThisThread::sleep_for(100);
    //led = 1 ;  // Initially off
    
    led1 = 0 ; led2=0; led3=0; led4=0; led5=0;
    while (true) {
        osEvent evt = mailbox.get(); // wait for mail 
        if (evt.status == osEventMail) {
            message_t* mess = (message_t*)evt.value.p ;
            

            if (pressEvent) {
                maxvolt = (mess->analog * 330) / 0xffff ;
                pressEvent = 0 ; // Clear the event variable
            }
            volts = (mess->analog * 330) / 0xffff ;
            mailbox.free(mess) ;  // free the message space
            led1 = 0 ; led2=0; led3=0; led4=0; led5=0;
            if (volts>=maxvolt/6){
                led1=1;                
                if (volts>=2*maxvolt/6){
                    led2=1;
                    if (volts>=3*maxvolt/6){
                        led3=1;
                        if (volts>=4*maxvolt/6){
                            led4=1;
                            if (volts>=5*maxvolt/6){
                                led5=1;
                            }
                        }
                    }
                }
            }


            vToString(maxvolt, vstring) ;
            counter++ ;
            if (counter == 10) {  // limit bandwidth of serial
                pc.printf(vstring) ;
                counter = 0 ;
            }
        }
    }
}
