#include "mbed.h"
#include "EthernetInterface.h"

#define ECHO_SERVER_PORT   7
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
int x;

int main (void) {
    EthernetInterface eth;
    eth.init(); //Use DHCP
    eth.connect();
    printf("IP Address is %s\n\r", eth.getIPAddress());
    
    TCPSocketServer server;
    server.bind(9999);
    server.listen();
    
    while (true) {
        printf("Wait for new connection...\n");
        TCPSocketConnection client;
        server.accept(client);
        //client.set_blocking(false, 1500); // Timeout after (1.5)s
        
        printf("Connection from: %s\n", client.get_address());
        char buffer[1];
        while (true) 
        {
            printf("%s",buffer);
            if(client.send(buffer, sizeof(buffer)))
            {
                led1=1;
                wait(1);
                led1=0;   
            }
                
                int n = client.receive(buffer, sizeof(buffer));
                if (n <= 0) break;
                client.send_all(buffer, n);
                if (n <= 0) break;
        }   
        client.close();
    }
}
