//heater_cutoff control using LM75B Temp sensor and Pot1 as inputs and LED1 and 2 as too hot and too cold tempreture indicators. 
//LED 3 is used to indicate heater_cutoff_cutoff on/off

#include "mbed.h"
#include "C12832_lcd.h"
#include "LM75B.h"

DigitalOut toast_ready(LED1);
DigitalOut toast_hold(LED2);
DigitalOut heater_cutoff(LED3);

C12832_LCD disp;
LM75B temp(p28,p27);
AnalogIn therm(p19);

float toast_temp;
float max_set;

int main()
{
    toast_hold=0;
    toast_ready=0;
    
    while(1) 
    {

    max_set=therm.read() *150.0f;// Reading and caliberating the thermostat setting 
    toast_temp=temp.read();
    disp.cls(); // clear the screen
    disp.locate(0,0);
    disp.printf("Max Temperature: %.2fc", max_set);
    disp.locate(0,10);
    disp.printf("toaster Temperature: %.2fc", toast_temp);
    
    if (toast_temp>24.0f)
    {   
        toast_hold=0;
        toast_ready=1;
    }
    else 
    {
        toast_hold=1;
        toast_ready=0;
    }
    
    if(toast_temp>max_set)
        heater_cutoff=1;
    else
        heater_cutoff=0;

    
     wait(0.1);  
    }
}
