/* USBJoystick.h */
/* USB device example: Joystick*/
/* Copyright (c) 2011 ARM Limited. All rights reserved. */
/* Modified Mouse code for Joystick - WH 2012 */

// PS3向け改修版

#ifndef USBJOYSTICK_H
#define USBJOYSTICK_H

#include "USBHID.h"

#define REPORT_ID_JOYSTICK  4

#define JOYSTICK_UP    (1<<0)
#define JOYSTICK_DOWN  (1<<1)
#define JOYSTICK_LEFT  (1<<2)
#define JOYSTICK_RIGHT (1<<3)

class USBJoystick: public USBHID
{
    private:
        int8_t      _x;
        int8_t      _y;
        int8_t      _z;
        int8_t      _rz;
        uint32_t        _buttons;
        uint8_t     _stick; 
        
        void _init();

   public:
        /**
         *   Constructor
         *
         * @param vendor_id Your vendor_id (default: 0x1234)
         * @param product_id Your product_id (default: 0x0002)
         * @param product_release Your product_release (default: 0x0001)
         */
         USBJoystick(uint16_t vendor_id = 0x1234, uint16_t product_id = 0x0100, uint16_t product_release = 0x0001): 
             USBHID(0, 0, vendor_id, product_id, product_release, false)
             { 
                 _init();
                 connect();
             };
         
         /**
         * Write a state of the mouse
         *
         * @param x  x-axis position
         * @param y  y-axis position
         * @param z  z-axis position
         * @param rz rotate-z position
         * @param buttons buttons state
         * @param stick rest of buttons, and hat state 0 (up), 1 (right, 2 (down), 3 (left) or 4 (neutral)
         * @returns true if there is no error, false otherwise
         */
         bool update(int16_t x, int16_t y, int16_t z, int16_t rz, uint32_t buttons, uint8_t stick);

         /**
         * Write a state of the mouse
         *
         * @returns true if there is no error, false otherwise
         */
         bool update();

         
         /*
         * To define the report descriptor. Warning: this method has to store the length of the report descriptor in reportLength.
         *
         * @returns pointer to the report descriptor
         */
         virtual uint8_t * reportDesc();

};

#endif