#include "NiseKabuto.h"

//
// Constructor
//
Out_PS3USB::Out_PS3USB(InputStatus *inputStatus)
{
//  wait(1);
    _InputStatus = inputStatus;
    _MyJS = new USBJoystick();
    Initialize();
}

//
// Initialize
//
void Out_PS3USB::Initialize()
{

    // Pin Setting

    // Class Variable Setting
    
    // Interrupt Setting
    _USBUpdateTicker.attach_us(this, &Out_PS3USB::USBUpdate, USBUPDATEINTERVAL__MSEC*1000);
}


//
// USB Joystick Update Method
//
void Out_PS3USB::USBUpdate()
{
    int16_t x;
    int16_t y;
    int16_t z;
    int16_t rz;
    uint32_t buttons;
    uint8_t button_hat;
    
    int in_Buttons;
    
    in_Buttons = _InputStatus->Buttons;
    
    // Dボタンが押されている/押されていないで送る情報を変える
    
    if( (in_Buttons & 0x0010) )
    {
        // Dボタン押されてない
        
        x =  (int)(0x80 + _InputStatus->Ch1)& 0xff; // x
        y =  (int)(0x80 + _InputStatus->Ch0)& 0xff; // y
        z =  (int)(0x80 + 0x80)     & 0xff;         // z
        rz = (int)(0x80 + _InputStatus->Ch2)& 0xff; // rz

        buttons = 
            ((in_Buttons & 0x0020)? 0: 0x0001) |    // button   □
            ((in_Buttons & 0x0100)? 0: 0x0002) |    //          ×
            ((in_Buttons & 0x0200)? 0: 0x0004) |    //          ○
                                            0  |    //          △
            ((in_Buttons & 0x0008)? 0: 0x0010) |    //          L1
            ((in_Buttons & 0x0004)? 0: 0x0020) |    //          R1
                                            0  |    //          L2
                                            0  |    //          R2
            ((in_Buttons & 0x0001)? 0: 0x0100) |    //          SELECT
            ((in_Buttons & 0x0002)? 0: 0x0200) |    //          START
                                            0  |    //          L3
                                            0  |    //          R3
                                            0  ;    //          PS button

        button_hat = 0;

    }
    else
    {
        // Dボタン押されてる
        
        x =  (int)(0x80 + 0x80)& 0xff;                  // x
        y =  (int)(0x80 + 0x80)& 0xff;                  // y
        z =  (int)(0x80 + _InputStatus->Ch2) & 0xff;    // z
        rz = (int)(0x80 + 0x80)& 0xff;                  // rz

        buttons = 
                                            0  |    // button   □
                                            0  |    //          ×
                                            0  |    //          ○
            ((in_Buttons & 0x0100)? 0: 0x0008) |    //          △
                                            0  |    //          L1
                                            0  |    //          R1
            ((in_Buttons & 0x0008)? 0: 0x0040) |    //          L2
            ((in_Buttons & 0x0004)? 0: 0x0080) |    //          R2
                                            0  |    //          SELECT
                                            0  |    //          START
            ((in_Buttons & 0x0200)? 0: 0x0400) |    //          L3
            ((in_Buttons & 0x0020)? 0: 0x0800) |    //          R3
            ((in_Buttons & 0x0002)? 0: 0x1000) ;    //          PS button

        button_hat =
            (( (_InputStatus->Ch0<0x20) )? 0x01: 0) |   // hat  up
            (( (_InputStatus->Ch0>0xe0) )? 0x02: 0) |   //      down
            (( (_InputStatus->Ch1<0x10) )? 0x04: 0) |   //      left
            (( (_InputStatus->Ch1>0xe0) )? 0x08: 0) ;   //      right
    }
    
    _MyJS->update(x, y, z, rz, buttons, button_hat);
    
    /*
    _MyJS->update(  //int16_t x, int16_t y, int16_t z, int16_t rz, uint32_t buttons, uint8_t button_hat
        (int)(0x80 + _InputStatus->Ch1)& 0xff,  // x
        (int)(0x80 + _InputStatus->Ch0)& 0xff,  // y
        (int)(0x80 + 0x80)     & 0xff,          // z
        (int)(0x80 + _InputStatus->Ch2)& 0xff,  // rz

        ((_InputStatus->Buttons & 0x0020)? 0: 0x0001) |                                 // button   □
        ((_InputStatus->Buttons & 0x0100)? 0: 0x0002) |                                 //          ×
        ((_InputStatus->Buttons & 0x0200)? 0: 0x0004) |                                 //          ○
        ((!(_InputStatus->Buttons & 0x0010) && !(_InputStatus->Buttons & 0x0100))? 0x0008: 0) | //          △
        ((_InputStatus->Buttons & 0x0008)? 0: 0x0010) |                                 //          L1
        ((_InputStatus->Buttons & 0x0004)? 0: 0x0020) |                                 //          R2
        ((!(_InputStatus->Buttons & 0x0010) && !(_InputStatus->Buttons & 0x0008))? 0x0040: 0) | //          L2
        ((!(_InputStatus->Buttons & 0x0010) && !(_InputStatus->Buttons & 0x0004))? 0x0080: 0) | //          R2
        ((_InputStatus->Buttons & 0x0001)? 0: 0x0100) |                                 //          SELECT
        ((_InputStatus->Buttons & 0x0002)? 0: 0x0200) |                                 //          START
        ((!(_InputStatus->Buttons & 0x0010) && (_InputStatus->Ch2<0x20))? 0x0400: 0)        |   //          L3?
        ((!(_InputStatus->Buttons & 0x0010) && (_InputStatus->Ch2>0xe0))? 0x0800: 0)        |   //          R3?
        ((!(_InputStatus->Buttons & 0x0010) && !(_InputStatus->Buttons & 0x0002))? 0x1000: 0),  //          PS button

        ((!(_InputStatus->Buttons & 0x0010) && (_InputStatus->Ch0<0x20))? 0x01: 0) |    // hat  up
        ((!(_InputStatus->Buttons & 0x0010) && (_InputStatus->Ch0>0xe0))? 0x02: 0) |    //      down
        ((!(_InputStatus->Buttons & 0x0010) && (_InputStatus->Ch1<0x10))? 0x04: 0) |    //      left
        ((!(_InputStatus->Buttons & 0x0010) && (_InputStatus->Ch1>0xe0))? 0x08: 0)      //      right
    );
    */
}





void Out_PS3USB::SetupInputControll(void (*startInputFunction)(void), void (*stopInputFunction)(void))
{
    StartInputFunction = startInputFunction;
    StopInputFunction  = stopInputFunction;
}

void Out_PS3USB::EnableInput(void)
{
    if(_InputInstance && StartInputMethod)
    {
        (_InputInstance->*StartInputMethod)();
    }
    else if(StartInputFunction)
    {
        StartInputFunction();
    }
}

void Out_PS3USB::DisableInput(void)
{
    if(_InputInstance && StopInputMethod)
    {
        (_InputInstance->*StopInputMethod)();
    }
    else if(StopInputFunction)
    {
        StopInputFunction();
    }
}


