/** Class: Out_PCE
 *
 * Output class for PC-Engine Analog/Digital stick
 *
 */

// ゲームごとによって微妙なタイミングの差異があると思われる。
// XHE-3実機があればもっと調査できたかもしれない。

#include "mbed.h"
#include "InputStatus.h"

class Out_PCE
{
public:
    /** Constructor: Out_PCE
     *
     * Parameters:
     * pn_1Y        - DigitalOut for 1Y(Up/trigI)     (PCE pad connector's pin2)
     * pn_2Y        - DigitalOut for 2Y(Right/trigII) (pin3)
     * pn_3Y        - DigitalOut for 3Y(Down/Select)  (pin4)
     * pn_4Y        - DigitalOut for 4Y(Left/Run)     (pin5)
     * pn_DSEL      - InterruptIn for DATASEL         (pin6)
     * pn_ST        - InterruptIn for /STROBE         (pin7)
     * pn_POWDETECT - InterruptIn for PowerDetect     (pin1)
     * inputStatus  - Input status
     */

    Out_PCE(
        PinName pn_1Y, PinName pn_2Y, PinName pn_3Y, PinName pn_4Y, 
        PinName pn_DSEL, PinName pn_ST, PinName pn_POWDETECT, 
        InputStatus *inputStatus
    );
     
private:
    // Private constants
    // ---- Analog ----
    static const int TRANSFERSPEED_MAX__MICROSEC    = 50;    // from AJOY_SUB.DOC
    static const int TRANSFERSPEED_1_2__MICROSEC    = 96;
    static const int TRANSFERSPEED_1_3__MICROSEC    = 144;
    static const int TRANSFERSPEED_1_4__MICROSEC    = 192;
    static const int MODECHECKPERIOD__MICROSEC      = 5000;
    // ---- Digital ----
    static const int DIGITALPAD_PHASECOUNT_MAX              = 10;
    static const int DIGITALPAD_STATERENEWINTERVAL__MICROSEC= 5000;
    
    // mbed pins
    DigitalOut   _OUT_1Y;
    DigitalOut   _OUT_2Y;
    DigitalOut   _OUT_3Y;
    DigitalOut   _OUT_4Y;
    InterruptIn  _INTR_DSEL;
    InterruptIn  _INTR_ST;
    InterruptIn  _INTR_POWDETECT;

    // Variable
    volatile char   _OutputMode;
    InputStatus     *_InputStatus;
    volatile char   _NowWriting;
    volatile char   _DataSelectStatus;

    volatile char   _PhaseCounter;
    Ticker          _PhaseChangeTicker;
    int             _TransferSpeed;

    volatile char   _Buttons;
    volatile char   _Ch0;
    volatile char   _Ch1;
    volatile char   _Ch2;

    volatile char   _RapidFireValue;
    volatile char   _PhaseData[12];

    Ticker          _PCEPowerCheckTicker;
    volatile int    _PCEActiveCounter;  // 不要？

    Ticker          _DigitalPadPhase0SetTicker;
    
    Ticker          _ModeCheckTicker;
    
    // Private Method
    void Initialize(void);
    void InitializePowerChecker(void);
    void SetOutputPinsValue(char dat);
    void SetOutputPinsValue2(char dat);
    void RenewPins(void);
    
    void DSelFallISR(void);
    void DSelRiseISR(void);
    void StrobeFallISR(void);
    void StrobeRiseISR(void);
    
    void AttachTicker(void);
    void DetachTicker(void);
    void ChangePhase(void);

    void Enable_DigitalPadPhase0SetTicker(void);
    void Digital_TickerMethod(void);
    void Digital_SetDataOfPhase(char phaseCounter);
//    void InitInterruptPriority(void);
    void ModeChecker(void);

//
// for InputControll
//
public:
    void SetupInputControll(void (*startInputFunction)(void), void (*stopInputFunction)(void));
    class CDummy;
    template<class T>
    void SetupInputControll(T* inputInstance, void (T::*startInputMethod)(void), void (T::*stopInputMethod)(void))
    {
        _InputInstance    = (CDummy*) inputInstance;
        StartInputMethod = (void (CDummy::*)(void)) startInputMethod;
        StopInputMethod  = (void (CDummy::*)(void)) stopInputMethod;
    }

private:
    CDummy*         _InputInstance;
    void (CDummy::*StartInputMethod)(void);
    void (CDummy::*StopInputMethod)(void);
    void (*StartInputFunction)(void);
    void (*StopInputFunction)(void);
    void EnableInput(void);
    void DisableInput(void);

};


