#include "mbed.h"
#include "Cfunc_PCEDigital.h"

// mbed pins
DigitalOut  *_OUT_1Y;
DigitalOut  *_OUT_2Y;
DigitalOut  *_OUT_3Y;
DigitalOut  *_OUT_4Y;
//BusOut      *_OUT_BUS;
InterruptIn *_INTR_DSEL;
InterruptIn *_INTR_ST;

// File local variables
static volatile char    *_PhaseData;    //PhaseData[12]
static volatile char    *_pRapidFireValue;
static volatile char    *_pTemp;

// Static variables
static const int DIGITALPAD_PHASECOUNT_MAX = 10;

// File local functions
void DSelRiseISR(void);
//void StrobeRiseISR(void);
static void SetOutputPinsValue(char dat);



void Cfunc_PCEDigital_Initialize(
    DigitalOut  *out_1Y,
    DigitalOut  *out_2Y,
    DigitalOut  *out_3Y,
    DigitalOut  *out_4Y,
    //BusOut      *out_bus,
    InterruptIn *intr_DSEL,
    InterruptIn *intr_ST,
    volatile char *pPhaseData,
    volatile char *pRapidFireValue,
    volatile char   *pTemp
    /*
    volatile char   *pCh0,
    volatile char   *pCh1,
    volatile char   *pCh2,
    volatile int    *pButtons,
    volatile char   *pInputDeviceType
    */
)
{
    // 入出力pin
    _OUT_1Y     = out_1Y;
    _OUT_2Y     = out_2Y;
    _OUT_3Y     = out_3Y;
    _OUT_4Y     = out_4Y;
    //_OUT_BUS    = out_bus;
    _INTR_DSEL  = intr_DSEL;
    _INTR_ST    = intr_ST;

    // PhaseDataポインタ
    _PhaseData = pPhaseData;
    
    _pRapidFireValue = pRapidFireValue;
    
    _pTemp =pTemp;
    
    // Inetrrupt Setting
//    _INTR_DSEL->rise(&DSelRiseISR);
    _INTR_ST->rise(&DSelRiseISR);

    // Initialize pin status
    SetOutputPinsValue(0x00);
    
}


void DSelRiseISR(void)
{
    //printf("I\r\n");
    //////////////////////////////////////
    char dselStatus =0;
    //char loopCounter = 200;
    int loopCounter = 200;

    // Phase0(DSEL=1)の期間、待機
    while( (_INTR_DSEL->read()) )
    {
        
        loopCounter--;
        if( loopCounter<0 )
        {
            break;
        }
        
    }
    
    
    // ただちにPhase1に移行
    // Set data for current phase
    SetOutputPinsValue(_PhaseData[1]);
    
    // 開始
    for(int i=2; i< DIGITALPAD_PHASECOUNT_MAX; i++ )
    {
         loopCounter = 200;
        
        while( _INTR_DSEL->read()==dselStatus )
        {
            
            loopCounter--;
            if( loopCounter<0 )
            {
                break;
            }
            
        }

        // Set data for current phase
        SetOutputPinsValue(_PhaseData[i]);

    
        dselStatus = !dselStatus;
    }

    loopCounter = 200;
    while( _INTR_DSEL->read()==dselStatus )
    {
        loopCounter--;
        if( loopCounter<0 )
        {
            break;
        }
    }
    SetOutputPinsValue(_PhaseData[0]);

    *_pRapidFireValue = !(*_pRapidFireValue);
    //printf("O\r\n");
    (*_pTemp)++;    // デバッグ用

    //NVIC_EnableIRQ(TIMER3_IRQn); // Tickerルーチンが呼ばれなくなる問題
    //LPC_TIM3->IR = 0xff;                    // clear interrupt flags
    //LPC_TIM3->TCR = 1;           // Enable Timer 悪化
}



void SetOutputPinsValue(char dat)
{
    _OUT_1Y->write(  dat & 1       );
    _OUT_2Y->write( (dat & 2) >> 1 );
    _OUT_3Y->write( (dat & 4) >> 2 );
    _OUT_4Y->write( (dat & 8) >> 3 );
    //_OUT_BUS->write(dat);
}
