/** Class: Out_FC
 *
 * Output class for Famicom
 *
 */
#include "mbed.h"
#include "InputStatus.h"

class Out_FC
{
public:
    /** Constructor: Out_FC
     *
     * Parameters:
     * pn_LATCH     - InterruptIn for LATCH       (pin12)
     * pn_DATA      - DigitalOut for DATA         (pin13)
     * pn_CLOCK     - InterruptIn for LATCH       (pin14)
     * pn_POWDETECT - InterruptIn for PowerDetect (pin15)
     * inputStatus  - Input status
     */

    Out_FC(
        PinName pn_LATCH, PinName pn_DATA, PinName pn_CLOCK, PinName pn_POWDETECT,
        InputStatus *inputStatus
    );
     
private:
    // Private constants
    static const int FC_INPUTSTATE_RENEWINTERVAL__MICROSEC = 2000;
    
    // mbed pins
    InterruptIn  _INTR_LATCH;
    DigitalOut   _OUT_DATA;
    InterruptIn  _INTR_CLOCK;
    InterruptIn  _INTR_POWDETECT;

    // Variable
    volatile int    _Buttons;
    volatile char   _Ch0;
    volatile char   _Ch1;
    volatile char   _Ch2;
    volatile char   _InputDeviceType;
    InputStatus     *_InputStatus;
    Ticker          _RenewFCInputTicker;
//  volatile char   _RapidFireValue;
    FunctionPointer _pEnableInput;
    FunctionPointer _pDisableInput;

    // Private Method
    void Initialize(void);
    void RenewFCInputDataPeriodically(void);
//  void InitInterruptPriority(void);






// for InputControll
public:
    void SetupInputControll(void (*startInputFunction)(void), void (*stopInputFunction)(void));
    class CDummy;
    template<class T>
    void SetupInputControll(T* inputInstance, void (T::*startInputMethod)(void), void (T::*stopInputMethod)(void))
    {
        _InputInstance    = (CDummy*) inputInstance;
        StartInputMethod = (void (CDummy::*)(void)) startInputMethod;
        StopInputMethod  = (void (CDummy::*)(void)) stopInputMethod;
    }

private:
    CDummy*         _InputInstance;
    void (CDummy::*StartInputMethod)(void);
    void (CDummy::*StopInputMethod)(void);
    void (*StartInputFunction)(void);
    void (*StopInputFunction)(void);
    void EnableInput(void);
    void DisableInput(void);

};


