#pragma once
/** Class: In_CyberStick
 *
 * Use CyberStick(CZ-8NJ2) as fake XE-1AP(Kabutogani) MD mode
 * Use CyberStick(CZ-8NJ2) as SS Multi Controller
 * Use CyberStick(CZ-8NJ2) as PC-Engine Analog Controller
 * Use CyberStick(CZ-8NJ2) Digital mode as Famicom controller
 * Use CyberStick(CZ-8NJ2) as PlayStation3 USB Joystick
 *
 * Example:
 *
 */
#include "In_CyberStick.h"
#include "In_MD6B.h"
#include "Out_MD.h"
#include "Out_SSMulCon.h"
#include "Out_PCE.h"
#include "Out_FC.h"
#include "Out_PS3USB.h"
#include "InputStatus.h"

static volatile int _Timer0Counter;

class NiseKabuto
{
public:
    // Public constants
    static const char CONFIG_INMODE_CYBERSTICK_ANALOG  = 0;
    static const char CONFIG_INMODE_CYBERSTICK_DIGITAL = 1;
    static const char CONFIG_INMODE_MD6B               = 2;

    static const char CONFIGPIN_OUTMODE_PS3USB    = 0;
    static const char CONFIGPIN_OUTMODE_SSMULCON  = 1;
    static const char CONFIGPIN_OUTMODE_PCE       = 2;
    static const char CONFIGPIN_OUTMODE_MD        = 3;  // changed!!
    static const char CONFIGPIN_OUTMODE_FC        = 4;
    
    // Public Method/Constructor
    NiseKabuto(PinName inputPins[], PinName outputPins[], PinName configurePins[]);
    void Show(void);

private:
    // Variables
    char                _InputType;
    char                _OutputType;
    In_CyberStick       *_In_CyberStick;
    In_MD6B             *_In_MD6B;
    Out_MD              *_Out_MD;
    Out_SSMulCon        *_Out_SSMulCon;
    Out_PCE             *_Out_PCE;
    Out_FC              *_Out_FC;
    Out_PS3USB          *_Out_PS3USB;
    InputStatus         _InputStatus;
    BusInOut            _ConfigSwitch;

    // Private Method
    void InitInterruptPriority(void);

    void InitInput_CyberStick (PinName inputPins[]);
    void InitInput_MD6B       (PinName inputPins[]);
    void InitOutput_MD        (PinName outputPins[]);
    void InitOutput_SSMulCon  (PinName outputPins[]);
    void InitOutput_PCE       (PinName outputPins[]);
    void InitOutput_FC        (PinName outputPins[]);
    void InitOutput_PS3USB    (void);

public:
    static void WaitUs(uint32_t us);
};

