#pragma once

/** Class: In_MD6B
 *
 * For reading input from Sega Fighting pad 6B
 *
 * Example:
 *
 * > #include "mbed.h"
 *
 * > In_MD6B myFightingPad6B(p20, p19,... inputStates);
 */

#include "mbed.h"
#include "InputStatus.h"

class In_MD6B
{
public:
    /** Constructor: In_MD6B
     *
     * Parameters:
     * pn_D0  - DigitalIn for 6B's D0 (D-Sub9 connector's pin1)
     * pn_D1  - DigitalIn for D1 (D-Sub9 pin2)
     * pn_D2  - DigitalIn for D2 (D-Sub9 pin3)
     * pn_D3  - DigitalIn for D3 (D-Sub9 pin4)
     * pn_D4  - DigitalIn for D4 (D-Sub9 pin6)
     * pn_D5  - DigitalIn for D5 (D-Sub9 pin9)
     * pn_SEL - DigitalOut for Select (D-Sub9 pin7)
     * inputStatus - The variable to store input status
     */
    In_MD6B(
        PinName pn_D0, PinName pn_D1, PinName pn_D2, PinName pn_D3, 
        PinName pn_D4, PinName pn_D5, PinName pn_SEL,
        InputStatus *inputStatus
    );

    void StartReading(void);
    void StopReading(void);
        
private:
    // Private constants
    static const int READINGINTERVAL__MICROSEC = 5000;  // reading period microsec
    static const int SELSTATETIME__MICROSEC    = 2;     // Select信号の立ち上げ_立ち下げを行う長さ
                                                        // 短すぎると6Bが反応しない？

    // mbed pins
    DigitalIn   _IN_D0;
    DigitalIn   _IN_D1;
    DigitalIn   _IN_D2;
    DigitalIn   _IN_D3;
    DigitalIn   _IN_D4;
    DigitalIn   _IN_D5;
    DigitalOut  _OUT_SEL;

    // Variables
    InputStatus     *_InputStatus;
    volatile char   _ReadEnable;
    Ticker          _PollingTicker;
    volatile char   _PhaseData[8];
    
    
    // Private Method
    void Initialize(void);
    void EnablePolling(void);
    void DisablePolling(void);
    void PollingMethod(void);

    int  ReadPinValue(void);
};
