/** Class: Out_PS3USB
 *
 * Output class for PlayStation3 USB Joystick
 *
 */

#include "mbed.h"
#include "InputStatus.h"
#include "USBJoystick.h"

class Out_PS3USB
{
public:
    /** Constructor: Out_PS3USB
     *
     * Parameters:
     * inputStatus  - Input status
     */

    Out_PS3USB(InputStatus *inputStatus);

private:
    // Private constants
    static const int USBUPDATEINTERVAL__MSEC = 10;
    
    // mbed pins

    // Variable
    InputStatus *_InputStatus;
    USBJoystick *_MyJS;
    Ticker      _USBUpdateTicker;
    
    // Private Method
    void Initialize(void);
    void USBUpdate(void);
//    void InitInterruptPriority(void);



// for InputControll
public:
    void SetupInputControll(void (*startInputFunction)(void), void (*stopInputFunction)(void));
    class CDummy;
    template<class T>
    void SetupInputControll(T* inputInstance, void (T::*startInputMethod)(void), void (T::*stopInputMethod)(void))
    {
        _InputInstance    = (CDummy*) inputInstance;
        StartInputMethod = (void (CDummy::*)(void)) startInputMethod;
        StopInputMethod  = (void (CDummy::*)(void)) stopInputMethod;
    }

private:
    CDummy*         _InputInstance;
    void (CDummy::*StartInputMethod)(void);
    void (CDummy::*StopInputMethod)(void);
    void (*StartInputFunction)(void);
    void (*StopInputFunction)(void);
    void EnableInput(void);
    void DisableInput(void);

};


