/** Class: Out_MD
 *
 * Used for writing to Megadrive analog joystick input mode
 *
 */

#include "mbed.h"
#include "InputStatus.h"

class Out_MD
{
public:
    /** Constructor: Out_MD
     *
     * Parameters:
     * pn_D0  - DigitalOut for Megadrive's D0 (D-Sub 9pin connector's pin1)
     * pn_D1  - DigitalOut for D1 (D-Sub9 pin2)
     * pn_D2  - DigitalOut for D2 (D-Sub9 pin3)
     * pn_D3  - DigitalOut for D3 (D-Sub9 pin4)
     * pn_LH  - DigitalOut for L/H (D-Sub9 pin6)
     * pn_REQ - InterruptIn for Req (D-Sub9 pin7)
     * pn_ACK - DigitalOut for Ack (D-Sub9 pin9)
     * inputStatus - The variable holds input status
     */

    Out_MD(
        PinName pn_D0, PinName pn_D1, PinName pn_D2, PinName pn_D3, 
        PinName pn_LH, PinName pn_REQ, PinName pn_ACK,
        InputStatus *inputStatus
    );
/*   
    void ShowReqInterval();
*/
    void SetupInputControll(void (*startInputFunction)(void), void (*stopInputFunction)(void));
    class CDummy;
    template<class T>
    void SetupInputControll(T* inputInstance, void (T::*startInputMethod)(void), void (T::*stopInputMethod)(void))
    {
        _InputInstance    = (CDummy*) inputInstance;
        StartInputMethod = (void (CDummy::*)(void)) startInputMethod;
        StopInputMethod  = (void (CDummy::*)(void)) stopInputMethod;
    }

    // Public constants
    static const int DIGITAL_PERIODICPOLLING_COUNTERMAX         = 12000;//7300; // 周期ポーリングカウンタ最大値
                                                                            // （ポーリングに使うカウンタ最大値）
    

private:
    // Private constants
    static const int REQUESTINTERVAL__MICROSEC      = 10000; // reading period 10msec
    static const int TRANSFERSPEED_MAX__MICROSEC    = 50;    // from AJOY_SUB.DOC
    static const int TRANSFERSPEED_1_2__MICROSEC    = 96;
    static const int TRANSFERSPEED_1_3__MICROSEC    = 144;
    static const int TRANSFERSPEED_1_4__MICROSEC    = 192;

    static const int DIGITAL_PERIODICPOLLING_INTERVAL__MICROSEC = 7000;//10000; // 周期ポーリングの間隔
                                                                            // （フレーム毎のゲーム機からのパッド読み取りの
                                                                            //   前後のみ、集中してポーリングを行う）

    static const int DIGITAL_STATE_RENEW_INTERVAL__MICROSEC     = 2000;     // 周期ポーリングの休みの間、デジタルパッド更新
    static const int MODECHECK_INTERVAL__MICROSEC   = 2000;                 // InputStatusのデジタルモード・アナログモード切替を見張る間隔

    // mbed pins
    DigitalOut   _OUT_D0;
    DigitalOut   _OUT_D1;
    DigitalOut   _OUT_D2;
    DigitalOut   _OUT_D3;
    DigitalOut   _OUT_LH;
    InterruptIn  _INTR_REQ;
    DigitalOut   _OUT_ACK;
    BusOut       _DataBus;

    // Variables
    InputStatus     *_InputStatus;
    volatile char   _InputMode;
    int             _TransferSpeed;
    Ticker          _DigitalStateRenewTicker;
    Ticker          _DigitalPeriodicPollingTicker;
    Ticker          _ModeChecker;
    volatile int    _ButtonStatus;
    char            _SwapAC;            // Aボタン-Cボタンをスワップする？(マスターシステム向け)
    char            _AnalogMUSHAMethod; // 武者アレスタ向けAnalog処理を使う？
    
    CDummy*         _InputInstance;

    
    // Private Method
    void Initialize(void);
//  void InitInterruptPriority(void);
    void ISR_Analog_ReqFall(void);
    void SetPinValue(int val);
    void SetData_Analog_PhaseOf(char phase);

    void DigitalStateRenewMethod(void);
    void EnableDigitalStateRenew(void);
    void DisableDigitalStateRenew(void);
    void RenewDigitalPadStatus(char phase);

    void RestartDigitalPeriodicPolling(void);
    void DigitalPeriodicPollingMethod(void);

    void EnableModeChecker(void);
    void DisableModeChecker(void);
    void ModeCheckerMethod(void);




    void (CDummy::*StartInputMethod)(void);
    void (CDummy::*StopInputMethod)(void);
    void (*StartInputFunction)(void);
    void (*StopInputFunction)(void);

    void EnableInput(void);
    void DisableInput(void);
};

