#include "mbed.h"
#include "CFunc_Out_MD.h"
#include "Out_MD.h"

// mbed pins
DigitalOut   *_OUT_D0;
DigitalOut   *_OUT_D1;
DigitalOut   *_OUT_D2;
DigitalOut   *_OUT_D3;
DigitalOut   *_OUT_LH;
InterruptIn  *_INTR_REQ;
DigitalOut   *_OUT_ACK;

// File local variables
static volatile int *_Buttons;
static volatile char _flagSwapAC;
// Static variables

// File local functions


void Cfunc_Out_MD_Initialize(
    DigitalOut  *out_D0,
    DigitalOut  *out_D1,
    DigitalOut  *out_D2,
    DigitalOut  *out_D3,
    DigitalOut  *out_LH,
    InterruptIn *intr_REQ,
    DigitalOut  *out_ACK,
    volatile int *pButtons,
    char        flagSwapAC
)
{
    // 入出力pin
    _OUT_D0   = out_D0;
    _OUT_D1   = out_D1;
    _OUT_D2   = out_D2;
    _OUT_D3   = out_D3;
    _OUT_LH   = out_LH;
    _INTR_REQ = intr_REQ;
    _OUT_ACK  = out_ACK;

    _flagSwapAC = flagSwapAC;

    // InputStatus
    _Buttons = pButtons;
}

void Cfunc_DigitalPeriodicPollingMethod(void)
{
    volatile int counter;
    volatile int readCounter = 0;   // REQ変化を検知してからのカウンタ値
    volatile int button = *_Buttons;    // ポインタ経由でアクセスすると処理全体で1us以上かかってしまう
    char detectedREQ_L = 0;
    char detectedREQ_H = 0;
    
    
    counter = Out_MD::DIGITAL_PERIODICPOLLING_COUNTERMAX;
    
    // カウンタ＞０の間だけ、真剣にポーリングする
    while(counter--)
    {
                
        if( _INTR_REQ->read() )
        {
            detectedREQ_H = 1;
            
            //RenewDigitalPadStatus(1);

            // phase1出力
            
            // MD C
            if(_flagSwapAC)
            {
                _OUT_ACK->write ( (button & 0x00200) ? 1 : 0 ); // Digital "A"
            }
            else
            {
                _OUT_ACK->write( (button & 0x00020) ? 1 : 0 ); // Digital "C"
            }
            // MD B
            _OUT_LH->write ( (button & 0x00100) ? 1 : 0 ); // Digital "B"
            // MD Right
            _OUT_D3->write ( (button & 0x00400) ? 1 : 0 ); // Digital "Right"
            // MD Left
            _OUT_D2->write ( (button & 0x00800) ? 1 : 0 ); // Digital "Left"
            // MD Down
            _OUT_D1->write ( (button & 0x01000) ? 1 : 0 ); // Digital "Down"
            // MD Up
            _OUT_D0->write ( (button & 0x02000) ? 1 : 0 ); // Digital "Up"
        }
        else
        {
            detectedREQ_L = 1;
            
            //RenewDigitalPadStatus(0);

            // phase0出力

            
            // サイバースティックのデジタルモードではStartボタンは読み取れない
            // (カブトガニは可能)
            // MD Start
            _OUT_ACK->write ( ((button & 0x00010)&&(button & 0x00002)) ? 1 : 0 ); // Digital "D" & "Start"

            // MD A
            if(_flagSwapAC)
            {
                _OUT_LH->write( (button & 0x00020) ? 1 : 0 ); // Digital "C"
            }
            else
            {
                _OUT_LH->write ( (button & 0x00200) ? 1 : 0 ); // Digital "A"
            }

            _OUT_D3->write ( 0 );
            _OUT_D2->write ( 0 );

            // MD Down
            _OUT_D1->write ( (button & 0x01000) ? 1 : 0 ); // Digital "Down"
            // MD Up
            _OUT_D0->write ( (button & 0x02000) ? 1 : 0 ); // Digital "Up"
            
        }

        // ゲーム機からの読み取り要求開始から
        // 一定時間たったら、ループ終了
        if(detectedREQ_L && detectedREQ_H)
        {
            if(readCounter++ > 800) // だいたい1msのつもり
            {
                counter=0;
                break;
            }
        }


    }

}



