#include "Out_FC.h"
#include "C_Out_FC.h"

//
// Constructor
//
Out_FC::Out_FC(
    PinName pn_LATCH, PinName pn_DATA, PinName pn_CLOCK, PinName pn_POWDETECT,
    InputStatus *inputStatus)
    : _INTR_LATCH(pn_LATCH), _OUT_DATA(pn_DATA), _INTR_CLOCK(pn_CLOCK), _INTR_POWDETECT(pn_POWDETECT)
{
    
    _InputStatus = inputStatus;
    
    Initialize();

    // C function Initializer
    
    _pEnableInput.attach(this, &Out_FC::EnableInput);
    _pDisableInput.attach(this, &Out_FC::DisableInput);
    
    C_Out_FC_Initialize(
        &_INTR_LATCH,
        &_OUT_DATA,
        &_INTR_CLOCK,
        &_INTR_POWDETECT,
        &_Buttons,
        &_Ch0,
        &_Ch1,
        &_Ch2,
    //  &_RapidFireValue,
        &_InputDeviceType,
        &_pEnableInput,
        &_pDisableInput
    );
}

//
// Initialize
//
void Out_FC::Initialize()
{
//  InitInterruptPriority();
    
    // Pin Setting
    _INTR_LATCH.mode(PullUp);
    _INTR_CLOCK.mode(PullUp);

    // Ticker Setting
    _RenewFCInputTicker.attach_us(
        this, 
        &Out_FC::RenewFCInputDataPeriodically, 
        FC_INPUTSTATE_RENEWINTERVAL__MICROSEC
    );
    
}


//
// 入力データ更新Ticker処理
//
void Out_FC::RenewFCInputDataPeriodically(void)
{
    _Buttons         = _InputStatus->Buttons;
    _Ch0             = _InputStatus->Ch0;
    _Ch1             = _InputStatus->Ch1;
    _Ch2             = _InputStatus->Ch2;
    _InputDeviceType = _InputStatus->InputDeviceType;
}



void Out_FC::SetupInputControll(void (*startInputFunction)(void), void (*stopInputFunction)(void))
{
    StartInputFunction = startInputFunction;
    StopInputFunction  = stopInputFunction;
}

void Out_FC::EnableInput(void)
{
    // Ticker Setting
    _RenewFCInputTicker.attach_us(
        this, 
        &Out_FC::RenewFCInputDataPeriodically, 
        FC_INPUTSTATE_RENEWINTERVAL__MICROSEC
    );

    if(_InputInstance && StartInputMethod)
    {
        (_InputInstance->*StartInputMethod)();
    }
    else if(StartInputFunction)
    {
        StartInputFunction();
    }
}

void Out_FC::DisableInput(void)
{
    _RenewFCInputTicker.detach();
    
    if(_InputInstance && StopInputMethod)
    {
        (_InputInstance->*StopInputMethod)();
    }
    else if(StopInputFunction)
    {
        StopInputFunction();
    }
}


