/* Copyright (c) 2010-2011 mbed.org, MIT License
* Modified Mouse code for Joystick - WH 2012
*
* Permission is hereby granted, free of charge, to any person obtaining a copy of this software
* and associated documentation files (the "Software"), to deal in the Software without
* restriction, including without limitation the rights to use, copy, modify, merge, publish,
* distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all copies or
* substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
* BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
* DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#include "stdint.h"
#include "USBJoystick.h"

bool USBJoystick::update(int16_t x, int16_t y, int16_t z, int16_t rz, uint32_t buttons, uint8_t stick)
{
    HID_REPORT report;
    int idx = 0;
    
    _x = x;
    _y = y;
    _z = z;
    _rz = rz;
    _buttons = buttons;
    _stick = stick;

    unsigned char hatswitch;
    if (_stick & JOYSTICK_UP) {
        hatswitch = 0;
        if (_stick & JOYSTICK_RIGHT) hatswitch = 1;
        if (_stick & JOYSTICK_LEFT) hatswitch = 7;
    } else if (_stick & JOYSTICK_RIGHT) {
        hatswitch = 2;
        if (_stick & JOYSTICK_DOWN) hatswitch = 3;
    } else if (_stick & JOYSTICK_DOWN) {
        hatswitch = 4;
        if (_stick & JOYSTICK_LEFT) hatswitch = 5;
    } else if (_stick & JOYSTICK_LEFT) {
        hatswitch = 6;
    } else {
        hatswitch = 0xf;
    }

   // Fill the report according to the Joystick Descriptor
    report.data[idx++] = _buttons & 0xff;
    report.data[idx++] = (_buttons>>8) & 0xff;
    report.data[idx++] = hatswitch & 0x0f;
    report.data[idx++] = _x + 0x80;
    report.data[idx++] = _y + 0x80;
    report.data[idx++] = _z + 0x80;
    report.data[idx++] = _rz + 0x80;

    report.data[idx++] = 0;
    report.data[idx++] = 0;
    report.data[idx++] = 0;
    report.data[idx++] = 0;
    report.data[idx++] = 0;
    report.data[idx++] = 0;
    report.data[idx++] = 0;
    report.data[idx++] = 0;
    report.data[idx++] = 0;
    report.data[idx++] = 0;
    report.data[idx++] = 0;
    report.data[idx++] = 0;
    report.length = idx; 

    return send(&report);
}
 
bool USBJoystick::update() 
{
    HID_REPORT report;
    int idx = 0;

    unsigned char hatswitch;
    if (_stick & JOYSTICK_UP) {
        hatswitch = 0;
        if (_stick & JOYSTICK_RIGHT) hatswitch = 1;
        if (_stick & JOYSTICK_LEFT) hatswitch = 7;
    } else if (_stick & JOYSTICK_RIGHT) {
        hatswitch = 2;
        if (_stick & JOYSTICK_DOWN) hatswitch = 3;
    } else if (_stick & JOYSTICK_DOWN) {
        hatswitch = 4;
        if (_stick & JOYSTICK_LEFT) hatswitch = 5;
    } else if (_stick & JOYSTICK_LEFT) {
        hatswitch = 6;
    } else {
        hatswitch = 0xf;
    }

   // Fill the report according to the Joystick Descriptor
    report.data[idx++] = _buttons & 0xff;
    report.data[idx++] = (_buttons>>8) & 0xff;
    report.data[idx++] = hatswitch & 0x0f;
    report.data[idx++] = _x + 0x80;
    report.data[idx++] = _y + 0x80;
    report.data[idx++] = _z + 0x80;
    report.data[idx++] = _rz + 0x80;

    report.data[idx++] = 0;
    report.data[idx++] = 0;
    report.data[idx++] = 0;
    report.data[idx++] = 0;
    report.data[idx++] = 0;
    report.data[idx++] = 0;
    report.data[idx++] = 0;
    report.data[idx++] = 0;
    report.data[idx++] = 0;
    report.data[idx++] = 0;
    report.data[idx++] = 0;
    report.data[idx++] = 0;
    report.length = idx; 

    return send(&report);
}



void USBJoystick::_init() 
{
    _x = 0;
    _y = 0;
    _z = 0;
    _rz = 0;
    _buttons = 0;
    _stick = 0;
}


uint8_t * USBJoystick::reportDesc() 
{
    static uint8_t reportDescriptor[] = 
    {
        0x05, 0x01, // USAGE_PAGE (Generic Desktop)
        0x09, 0x05, // USAGE (Gamepad)
        0xa1, 0x01, // COLLECTION (Application)

        0x15, 0x00, //   LOGICAL_MINIMUM (0)
        0x25, 0x01, //   LOGICAL_MAXIMUM (1)
        0x35, 0x00, //   PHYSICAL_MINIMUM (0)
        0x45, 0x01, //   PHYSICAL_MAXIMUM (1)
        0x75, 0x01, //   REPORT_SIZE (1)
        0x95, 0x0d, //   REPORT_COUNT (13)
        0x05, 0x09, //   USAGE_PAGE (Button)
        0x19, 0x01, //   USAGE_MINIMUM (Button 1)
        0x29, 0x0d, //   USAGE_MAXIMUM (Button 13)
        0x81, 0x02, //   INPUT (Data,Var,Abs)
        0x95, 0x03, //   REPORT_COUNT (3)
        0x81, 0x01, //   INPUT (Cnst,Ary,Abs)
        0x05, 0x01, //   USAGE_PAGE (Generic Desktop)
        0x25, 0x07, //   LOGICAL_MAXIMUM (7)
        0x46, 0x3b, 0x01, //   PHYSICAL_MAXIMUM (315)
        0x75, 0x04, //   REPORT_SIZE (4)
        0x95, 0x01, //   REPORT_COUNT (1)
        0x65, 0x14, //   UNIT (Eng Rot:Angular Pos)
        0x09, 0x39, //   USAGE (Hat switch)
        0x81, 0x42, //   INPUT (Data,Var,Abs,Null)
        0x65, 0x00, //   UNIT (None)
        0x95, 0x01, //   REPORT_COUNT (1)
        0x81, 0x01, //   INPUT (Cnst,Ary,Abs)

        0x26, 0xff, 0x00, //   LOGICAL_MAXIMUM (255)
        0x46, 0xff, 0x00, //   PHYSICAL_MAXIMUM (255)
        0x09, 0x30, //   USAGE (X)
        0x09, 0x31, //   USAGE (Y)
        0x09, 0x32, //   USAGE (Z)
        0x09, 0x35, //   USAGE (Rz)
        0x75, 0x08, //   REPORT_SIZE (8)
        0x95, 0x04, //   REPORT_COUNT (4)
        0x81, 0x02, //   INPUT (Data,Var,Abs)

        0x06, 0x00, 0xff, //   USAGE_PAGE (Vendor Specific)
        0x09, 0x20, //   Unknown
        0x09, 0x21, //   Unknown
        0x09, 0x22, //   Unknown
        0x09, 0x23, //   Unknown
        0x09, 0x24, //   Unknown
        0x09, 0x25, //   Unknown
        0x09, 0x26, //   Unknown
        0x09, 0x27, //   Unknown
        0x09, 0x28, //   Unknown
        0x09, 0x29, //   Unknown
        0x09, 0x2a, //   Unknown
        0x09, 0x2b, //   Unknown
        0x95, 0x0c, //   REPORT_COUNT (12)
        0x81, 0x02, //   INPUT (Data,Var,Abs)
        0x0a, 0x21, 0x26, //   Unknown
        0x95, 0x08, //   REPORT_COUNT (8)
        0xb1, 0x02, //   FEATURE (Data,Var,Abs)

        0xc0, // END_COLLECTION
        
    /*  
        USAGE_PAGE(1),      0x01,
        USAGE(1),           0x04,
        COLLECTION(1),      0x01,
        USAGE(1),           0x01,
        COLLECTION(1),      0x00,

        USAGE_PAGE(1),      0x09,
        USAGE_MINIMUM(1),       0x01,
        USAGE_MAXIMUM(1),       0x0C,
        LOGICAL_MINIMUM(1),     0x00,
        LOGICAL_MAXIMUM(1),     0x01,
        PHYSICAL_MINIMUM(1),    0x00,
        PHYSICAL_MAXIMUM(1),    0x01,
        REPORT_SIZE(1),     0x01,
        REPORT_COUNT(1),    0x0C,
        INPUT(1),           0x02,

        USAGE_PAGE(1),      0x01,
        USAGE(1),           0x39,
        LOGICAL_MINIMUM(1),     0x00,
        LOGICAL_MAXIMUM(1),     0x07,
        PHYSICAL_MINIMUM(1),    0x00,
        PHYSICAL_MAXIMUM(2),    0x3B, 0x01,
        UNIT(1),            0x14,
        REPORT_SIZE(1),     0x04,
        REPORT_COUNT(1),    0x01,
        INPUT(1),           0x42,

        USAGE_PAGE(1),      0x01,
        USAGE(1),           0x30,
        USAGE(1),           0x31,
        USAGE(1),           0x32,
        USAGE(1),           0x35,
        LOGICAL_MINIMUM(1),     0x00,
        LOGICAL_MAXIMUM(2),     0xff, 0x00,
        PHYSICAL_MINIMUM(1),    0x00,
        PHYSICAL_MAXIMUM(2),    0xff, 0x00,
        UNIT(2),            0x00, 0x00,
        REPORT_SIZE(1),     0x08,
        REPORT_COUNT(1),    0x04,
        INPUT(1),           0x02,

        END_COLLECTION(0),
        END_COLLECTION(0),
    */
    };

      reportLength = sizeof(reportDescriptor);
      return reportDescriptor;
}


