#pragma once
/** Class: InputStatus
 *
 * Used for store input status from Joypad/Joystick
 *
 */
class InputStatus
{
    public:
        volatile char   Ch0;    // axis_y
        volatile char   Ch1;    // axis_x
        volatile char   Ch2;    // throttle
        volatile char   Ch3;    // option

        volatile int    Buttons;
        // 32 bits
        // *MSB*
        //                                               |   X    |   Y    |   Z    |
        //  ------------------------------------------------------------------------
        //  ThrotUp |ThrotDw |   Up   |   Dw   ||   Lf   |   Rg   |   A    |   B    |
        //  ------------------------------------------------------------------------
        //    A+A'  |  B+B'  |   C    |   D    ||   E1   |   E2   |START(F)|SELECT(G)
        //          |        |        |        ||        |        |        |Mode
        //                                                                     *LSB*
        //

        volatile char   InputDeviceType;// 0:CS-Analog mode
                                        // 1:CS-Digital mode
                                        // 2:MD6B

        volatile char   Temp[8];
       
    public:
        void Reset(void)
        {
            Ch0 = 0x7f;
            Ch1 = 0x7f;
            Ch2 = 0x7f;
            Ch3 = 0x7f;
            Buttons = 0x7fffffff;
            InputDeviceType = 1;
        }
};

