#pragma once

/** Class: In_CyberStick
 *
 * Used for reading from CyberStick(CZ-8NJ2)
 *
 * Example:
 *
 * > #include "mbed.h"
 *
 * > In_CyberStick myCS(p20, p19,... inputStates);
 */

#include "mbed.h"
#include "InputStatus.h"

class In_CyberStick
{
public:
    /** Constructor: In_CyberStick
     *
     * Parameters:
     * pn_D0  - DigitalIn for CyberStick's D0 (D-Sub 9pin connector's pin1)
     * pn_D1  - DigitalIn for D1 (D-Sub9 pin2)
     * pn_D2  - DigitalIn for D2 (D-Sub9 pin3)
     * pn_D3  - DigitalIn for D3 (D-Sub9 pin4)
     * pn_LH  - DigitalIn for L/H (D-Sub9 pin6)
     * pn_ACK - DigitalIn for Ack (D-Sub9 pin7)
     * pn_REQ - DigitalOut for Req (D-Sub9 pin8)
     * inputStatus - The variable to store input status
     */
    In_CyberStick(
        PinName pn_D0, PinName pn_D1, PinName pn_D2, PinName pn_D3, 
        PinName pn_LH, PinName pn_ACK, PinName pn_REQ,
        InputStatus *inputStatus
    );

    void TestShow(void);
    
    void StartReading(void);
    void StopReading(void);
        
private:
    // Private constants
    static const int REQUESTINTERVAL__MICROSEC      = 2500; // reading period microsec
    static const int TRANSFERSPEED_MAX__MICROSEC    = 50;    // from AJOY_SUB.DOC
    static const int TRANSFERSPEED_1_2__MICROSEC    = 96;
    static const int TRANSFERSPEED_1_3__MICROSEC    = 144;
    static const int TRANSFERSPEED_1_4__MICROSEC    = 192;

    // mbed pins
    DigitalIn   _IN_D0;
    DigitalIn   _IN_D1;
    DigitalIn   _IN_D2;
    DigitalIn   _IN_D3;
    DigitalIn   _IN_LH;
    DigitalIn   _IN_ACK;
    DigitalOut  _OUT_REQ;

    // Variables
    InputStatus     *_InputStatus;
    volatile char   _ReadEnable;
    Ticker          _PollingTicker;
    Timer           _AckTimer;
    volatile int    _Buttons;
    volatile char   _Ch0;
    volatile char   _Ch1;
    volatile char   _Ch2;
    volatile char   _Ch3;
    volatile int    _AnalogReadFailCounter;

    // Private Method
    void Initialize(void);
    void EnablePolling(void);
    void DisablePolling(void);
    void PollingMethod(void);
    void ReadPhase(char phase);

    void DigitalModeReader(void);

    int  ReadPinValue(void);
    void CommitAnalogData(void);

};
