/*****Multiceiver wireless network*****/

#include "mbed.h"
#include "nRF24L01P.h"
 
Serial pc(USBTX, USBRX); // tx, rx
 
nRF24L01P my_nrf24l01p(PTD2, PTD3, PTD1, PTD0, PTD5, PTD4);    // mosi, miso, sck, csn, ce, irq

//blue for pipe1 and green for pipe0
DigitalOut GreenLED(LED2);
DigitalOut RedLED(LED1);
 
int main() {
    
    char RxDataCnt_PIPE0;
    char temp;
    char abc;
    char buff[1];
    GreenLED=1;
    RedLED=1;
    //specifying address same as transmitter for pipe0 and pipe1
   
    long long RxAddress_PIPE0 = 0xE7E7E7E7E7;
    
    my_nrf24l01p.powerUp();
    my_nrf24l01p.setRfFrequency(2425);
    
    //set rx address with default address and for specified pipe

    my_nrf24l01p.setRxAddress(RxAddress_PIPE0, DEFAULT_NRF24L01P_ADDRESS_WIDTH, NRF24L01P_PIPE_P0);
    
 
    // Display the (default) setup of the nRF24L01+ chip
    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    
    //display rx address for both pipes
    pc.printf( "nRF24L01+ RX Address - PIPE0  : 0x%010llX\r\n", my_nrf24l01p.getRxAddress(NRF24L01P_PIPE_P0) );
    
 
    pc.printf( "Wireless Sensor Network - Multiceiver\r\n" );
    
    RxDataCnt_PIPE0 = 1;

    
    //set transfer size explicitly for both pipes
  
    my_nrf24l01p.setTransferSize(RxDataCnt_PIPE0, NRF24L01P_PIPE_P0);
    
    my_nrf24l01p.setReceiveMode();
    my_nrf24l01p.enable();
 
    while (1) {
        
        //check if data is available in pipe0
        if ( my_nrf24l01p.readable(NRF24L01P_PIPE_P0) ) 
        {
 
            // ...read the data into the receive buffer
            temp = my_nrf24l01p.read( NRF24L01P_PIPE_P0, buff, RxDataCnt_PIPE0 );
            
            abc=buff[0];
 
            pc.printf("Received: %d bytes from PIPE0; POT=%d\r\n",temp,buff[0]);
           
           if(abc=='R')
           {
            pc.printf("%c",abc);
            RedLED =0; 
            }
            else if(abc=='r')
           {
             pc.printf("%c",abc);
            RedLED =1; 
            }
            else if(abc=='g')
           { pc.printf("%c",abc);
             GreenLED =1; 
             
            }
            else if(abc=='G')
            {
             pc.printf("%c",abc);
            GreenLED=0;
            }
       }
         wait_ms(100);
        }
        
       
       
    }
