
/* mbed Microcontroller Library
 * Copyright (c) 2006-2015 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
Implementation of Dance Tracker by sandeep ponnuru. Copyright (c) 2016-2018 Sandeep Ponnuru,
 All rights reserved.
*/
#include "mbed.h"
#include "stdio.h"
#include "SFE_MicroOLED.h"
#include "KX22.h"
#include "ble/BLE.h"

#define DEBUG 1 

#define REV 1
#define MINOR_REV 0
const char DEVICE_NAME[] ="DncTrkSan";

#define VIBRATE P0_7
#define BUTTON P0_4
//accelerometer
#define KX_SCL  P0_16  
#define KX_SDA  P0_14


    #define UART_TX     P0_18
    #define UART_RX     P0_17

#define BUT_BLE 1
#define BUT_UART 0 

#define APP_SPECIFIC_ID_TEST 0xDA78

#pragma pack(1)
struct AppData_t {
    int16_t  accX, accY, accZ;
} appData;
#pragma pack()

//got these numbers from roger! tx in tx
//vibrate motor
DigitalOut vib(VIBRATE);
//DigitalIn but(BUTTON, PullUp);
InterruptIn but(BUTTON);
int16_t accVal[3];
bool butState = BUT_BLE;
/*********OLED******************/
//from roger :: works!!!

//BLE
BLE ble;

/************KX ACC*************/

/***********Serial*****/
#if DEBUG
extern Serial pc(UART_TX, UART_RX);
#endif

void start_ble();
void stop_ble();
void update_ble();


//button call back function 
void but_callback(){

      
    SPI* my_spi = new SPI(P0_29, NC, P0_30);
    MicroOLED* oled = new MicroOLED(*my_spi, P0_1, P0_0, P0_2);
    oled->init(0, 8000000);
    oled->clear(PAGE);
    oled->clear(ALL);
    oled->printf("Acc values:%d,%d,%d\n",
                               accVal[0],
                               accVal[1],
                               accVal[2]);
    oled->display(); 
    wait(2);
    oled->clear(PAGE);
    oled->clear(ALL);
    oled->display(); 
    delete(oled);
    delete(my_spi);
   
    /* 
    // handle BLE state 
    butState = !butState;
    if(butState==BUT_UART)
     stop_ble();
    else
     start_ble(); 
    */
}

void wakeup_event_cb() {
    //nothing to do
}
void start_ble(){
 
   ble.init();
   ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));
   ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED 
                        | GapAdvertisingData::LE_GENERAL_DISCOVERABLE); /* Set flag */
   ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::GENERIC_CYCLING); /* Set appearance */
   ble.gap().accumulateAdvertisingPayload(
   GapAdvertisingData::MANUFACTURER_SPECIFIC_DATA, 
   (uint8_t *)&appData , sizeof(AppData_t)); /* Set data as int16 array*/
    /* Setup advertising parameters */
   ble.gap().setAdvertisingType(GapAdvertisingParams::ADV_NON_CONNECTABLE_UNDIRECTED);
   ble.gap().setAdvertisingInterval(1000);
    /* Start advertising */
   ble.gap().startAdvertising();
    
    
}

void stop_ble(){
    ble.shutdown();
    }
    
void update_ble(){
    
    ble.gap().stopAdvertising();
          ble.gap().updateAdvertisingPayload(GapAdvertisingData::MANUFACTURER_SPECIFIC_DATA,
           (uint8_t *)&appData, sizeof(AppData_t));
          ble.gap().startAdvertising();
          
    }    
    
int main(void)
{
    Ticker ticker;
    ticker.attach(wakeup_event_cb, 1);
    
    #if DEBUG
    pc.printf("Dance Tracker v 1.2 welcomes you! \n\n \t\t c. Sandeep Ponnuru\n\n");
    #endif
    vib =1;
    wait(0.25);
    vib=0;
    #if DEBUG
    pc.printf("Vibration check passed\n");
    
    pc.baud(9600);
    pc.printf("Serial setup to 9600 bps!! \n");
    #endif
   // start BLE setup
   appData.accX = 0xABAB;
   appData.accY = 0xABAD;
   appData.accZ = 0xABAC;
   start_ble();
   
   
     // OLED part of code
    SPI* my_spi = new SPI(P0_29, NC, P0_30);
    MicroOLED* oled = new MicroOLED(*my_spi, P0_1, P0_0, P0_2);
    //delete(my_spi);
    #if DEBUG
    pc.printf("OLED setting up \n");
    #endif
    oled->init(0, 8000000);
    #if DEBUG
    pc.printf("OLED init \n");
    #endif
    oled->clear(PAGE);
    #if DEBUG
    pc.printf("OLED clear page \n");
    #endif
    oled->clear(ALL);
    #if DEBUG
    pc.printf("OLED clear all \n");
    #endif
    oled->printf("Dance Tracker version %d.%d",REV,MINOR_REV);
    #if DEBUG
    pc.printf("OLED print \n");
    #endif
    oled->display();
    #if DEBUG
    pc.printf("OLED set complete\n");
    #endif
    wait(2);   
    
    delete(oled);
    delete(my_spi);
    
    but.fall(but_callback); 
    int intl_cnt = 0;
    while (true) {
        
    
            KX22* acc = new KX22(KX_SCL, KX_SDA);
            //pc.printf("going to print vals now\n");
            
            
            for(int k=0;k<3;k++)
              accVal[k] = acc->getAccel(k);
            delete(acc);        
    intl_cnt++;
    if(intl_cnt== 10)
       { 
    #if DEBUG
         pc.printf("Acc values:%d,%d,%d\n",
                               accVal[0],
                               accVal[1],
                               accVal[2]);
             
    #endif                  
          //update the BLE payload here
    if(butState== BUT_BLE)
          {
              appData.accX = accVal[0];
          appData.accY = accVal[1];
          appData.accZ = accVal[2];
          update_ble();
          }                
         intl_cnt=0;
         }                      
    wait(0.12);//update of the acc variable is done at this speed
   ble.waitForEvent();
    }
       
    
    
}
