
#include "KX22.h"
#include "mbed.h"
extern Serial pc; 


 KX22::KX22(uint8_t SCL, uint8_t SDA){
    
    scl = SCL;
    sda = SDA;
    
    TwoWire* wire = new TwoWire(NRF_TWI1);
    (*wire).begin(scl, sda, TWI_FREQUENCY_100K);
    
    writeTwoBytes(KX22_Accel_CNTL1_1,KX22_Accel_CNTL1_2,wire);
    writeTwoBytes(KX22_Accel_ODCNTL_1,KX22_Accel_ODCNTL_2,wire);
    writeTwoBytes(KX22_Accel_CNTL3_1,KX22_Accel_CNTL3_2,wire);
    writeTwoBytes(KX22_Accel_TILT_TIMER_1,KX22_Accel_TILT_TIMER_2,wire);
    writeTwoBytes(KX22_Accel_CNTL2_1,KX22_Accel_CNTL2_2,wire);
    
    delete(wire);

}

void KX22::writeTwoBytes (int one, int two, TwoWire* wire)
{
    (*wire).beginTransmission(KX22_addr_w);
    (*wire).write(one);
    (*wire).write(two);
    (*wire).endTransmission();
}
//void writeTwoBytes (int one, int two)
int KX22::getByte (int address, TwoWire* wire)
{
  int readedValue= 0;
  (*wire).beginTransmission(KX22_addr_w);
  (*wire).write(address);
  (*wire).endTransmission();
  (*wire).requestFrom(KX22_addr_r , 1);  // Or-ed with "1" for read bit
  if(1 <= (*wire).available())    // if two bytes were received
  {
    readedValue = (*wire).read();
  }
  return readedValue;
}

//void writeTwoBytes (int one, int two)
//int getByte (int address)
int16_t KX22::getAccel(int channelNum)
{
  TwoWire* wire = new TwoWire(NRF_TWI1);
    (*wire).begin(scl, sda, TWI_FREQUENCY_100K);
    
  //pc.printf("Inside the getAccel: channel=%d\n",channelNum);
  int16_t accVal = (int16_t)( getByte(DATA_OUT_BASE+1 + 2*channelNum,wire)<<8 | 
                     getByte(DATA_OUT_BASE + 2*channelNum,wire) );
  //pc.printf("int code for accel value is %d\n",accVal);
  //pc.printf("float val is 1/100 of %d\n",(int16_t) 100*tmp/16384.0);
  delete(wire);
  accVal = (int16_t) (accVal*10000.0/16384.0);
  return  accVal; //(int16_t) 100*tmp/16384.0;  
}

